/*
 *  guicomponentwidgets.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Jul 01 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "guicomponentwidgets.h"

#include "MvcDigestDb/digestdbcontroller.h"


/*!
 * Constructs a QWidget DigestDb component with the given \em parent and
 * \em flags and attaches itself to the \em controller.
 */
GuiDbComponentWidget::GuiDbComponentWidget( AbstractController* controller,
					    QWidget* parent,
					    Qt::WindowFlags flags )
  : QWidget(parent, flags),
    AbstractDigestDbView(this)
{
  Q_ASSERT( controller != 0 );
  controller->attachView( this );
}

/*! Passes event onto QWidget and then emits visibilityToggled(). */
void GuiDbComponentWidget::showEvent( QShowEvent* event ) {
  QWidget::showEvent( event );
  emit visibilityToggled();
}

/*! Passes event onto QWidget and then emits visibilityToggled(). */
void GuiDbComponentWidget::hideEvent( QHideEvent* event ) {
  QWidget::hideEvent( event );
  emit visibilityToggled();
}


/*!
 * Constructs a QDialog DigestDb component with the given \em parent and
 * \em flags and attaches itself to the \em controller.
 */
GuiDbComponentDialog::GuiDbComponentDialog( AbstractController* controller,
					    QWidget* parent,
					    Qt::WindowFlags flags )
  : QDialog(parent, flags),
    AbstractDigestDbView(this)
{
  Q_ASSERT( controller != 0 );
  controller->attachView( this ); // TODO: re-enable me!
}

/*! Passes event onto QDialog and then emits visibilityToggled(). */
void GuiDbComponentDialog::showEvent( QShowEvent* event ) {
  QDialog::showEvent( event );
  emit visibilityToggled();
}

/*! Passes event onto QDialog and then emits visibilityToggled(). */
void GuiDbComponentDialog::hideEvent( QHideEvent* event ) {
  QDialog::hideEvent( event );
  emit visibilityToggled();
}


/*!
 * Constructs a QMainWindow DigestDb component with the given \em parent and
 * \em flags and attaches itself to the \em controller.
 */
GuiDbComponentMainWindow::GuiDbComponentMainWindow( AbstractController* controller,
						    QWidget* parent,
						    Qt::WindowFlags flags )
  : QMainWindow(parent, flags),
    AbstractDigestDbView(this)
{
  Q_ASSERT( controller != 0 );
  controller->attachView( this );
}

/*! Passes event onto QMainWindow and then emits visibilityToggled(). */
void GuiDbComponentMainWindow::showEvent( QShowEvent* event ) {
  QMainWindow::showEvent( event );
  emit visibilityToggled();
}

/*! Passes event onto QMainWindow and then emits visibilityToggled(). */
void GuiDbComponentMainWindow::hideEvent( QHideEvent* event ) {
  QMainWindow::hideEvent( event );
  emit visibilityToggled();
}
