/*  -*- c++ -*-  (for Emacs)
 *
 *  guicomponentwidgets.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Jul 01 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUICOMPONENTWIDGETS_H
#define GUICOMPONENTWIDGETS_H


#include "MvcDigestDb/abstractdigestdbview.h"

#include <QDialog>
#include <QMainWindow>


class AbstractController;


/*!
 * \brief The GuiDbComponentWidget class is purely a convenience class that
 *        extends QWidget.
 *
 * The first extension is that it provides a visibilityToggled() signal.
 *
 * The second is that is extends AbstractDigestDbView.
 */
class GuiDbComponentWidget : public QWidget, public AbstractDigestDbView {

  Q_OBJECT

public:
  GuiDbComponentWidget( AbstractController* controller,
			QWidget* parent = 0, Qt::WindowFlags flags = 0 );

signals:
  void visibilityToggled();
  void request( const QString& message );

public slots:
  virtual void execMessage( const QString& message ) { Q_UNUSED(message); }

protected:
  DEFINE_CUSTOM_VIEWEVENT_HANDLER
  virtual void showEvent( QShowEvent* e );
  virtual void hideEvent( QHideEvent* e );
};



/*!
 * \brief The GuiDbComponentDialog class is purely a convenience class that
 *        extends QDialog.
 *
 * The first extension is that it provides a visibilityToggled() signal.
 *
 * The second is that is extends AbstractDigestDbView.
 */
class GuiDbComponentDialog : public QDialog, public AbstractDigestDbView {

  Q_OBJECT

public:
  GuiDbComponentDialog( AbstractController* controller,
			QWidget* parent = 0, Qt::WindowFlags flags = 0 );

signals:
  void visibilityToggled();
  void request( const QString& message );

public slots:
  virtual void execMessage( const QString& message ) { Q_UNUSED(message); }

protected:
  DEFINE_CUSTOM_VIEWEVENT_HANDLER
  virtual void showEvent( QShowEvent* e );
  virtual void hideEvent( QHideEvent* e );
};



/*!
 * \brief The GuiDbComponentMainWindow class is purely a convenience class that
 *        extends QMainWindow.
 *
 * The first extension is that it provides a visibilityToggled() signal.
 *
 * The second is that is extends AbstractDigestDbView.
 */
class GuiDbComponentMainWindow : public QMainWindow, public AbstractDigestDbView {

  Q_OBJECT

public:
  GuiDbComponentMainWindow( AbstractController* controller,
			    QWidget* parent = 0, Qt::WindowFlags flags = 0 );

signals:
  void visibilityToggled();
  void request( const QString& message );

public slots:
  virtual void execMessage( const QString& message ) { Q_UNUSED(message); }

protected:
  DEFINE_CUSTOM_VIEWEVENT_HANDLER
  virtual void showEvent( QShowEvent* );
  virtual void hideEvent( QHideEvent* );
};


#endif  // ! GUICOMPONENTWIDGETS_H
