/*  -*- c++ -*-  (for Emacs)
 *
 *  stdguidbcomponent.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Aug 02 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "stdguidbcomponent.h"

#include "guicomponentwidgets.h"


StdGuiDbComponent::StdGuiDbComponent( QWidget* widget,
				      AbstractController* controller,
				      JavaVM* jvm, QWidget* parent,
				      Qt::WindowFlags flags )
  : AbstractGuiDbComponent(controller, jvm, parent, flags),
    m_widget(widget)
{
  Q_ASSERT( m_widget );
  connect( m_widget,
	   SIGNAL(visibilityToggled()),
	   SIGNAL(rootWidgetVisibilityToggled()) );
  connect( m_widget,
	   SIGNAL(request(const QString&)),
	   SIGNAL(request(const QString&)) );
}

StdGuiDbComponent::~StdGuiDbComponent()
{
  delete m_widget;
}

bool StdGuiDbComponent::isRootWidgetVisible() const {
  Q_ASSERT( m_widget );
  return m_widget->isVisible();
}

bool StdGuiDbComponent::deleteOnCloseEnabled() const {
  Q_ASSERT( m_widget );
  return m_widget->testAttribute( Qt::WA_DeleteOnClose );
}

void StdGuiDbComponent::setDeleteOnClose( bool enable ) {
  Q_ASSERT( m_widget );
  m_widget->setAttribute( Qt::WA_DeleteOnClose, enable );
}

void StdGuiDbComponent::setRootWidgetVisible( bool visible ) {
  Q_ASSERT( m_widget );
  m_widget->setVisible( visible );
  m_widget->activateWindow(); // fixes focus probs (inactive title, resizegrip, etc..)
  m_widget->raise();
}

/*!
 * \b Note: \em windowState is only used of the widget is no already visible.
 */
void StdGuiDbComponent::showRootWidget( Qt::WindowStates windowState )
{
  Q_ASSERT( m_widget );
  if ( !m_widget->isVisible() ) { // check this to prevent messing-up the window state
    m_widget->setWindowState( windowState );
    m_widget->show();
  }
  m_widget->activateWindow(); // fixes focus probs (inactive title, resizegrip, etc..)
  m_widget->raise();
}

void StdGuiDbComponent::hideRootWidget() {
  Q_ASSERT( m_widget );
  m_widget->hide();
}


// FIXME: This is hacky - use a derivative of QEvent instead
void StdGuiDbComponent::execMessage( const QString& message ) {
  Q_ASSERT( m_widget );
  GuiDbComponentWidget* w1 = qobject_cast<GuiDbComponentWidget*>( m_widget );
  if ( w1 ) w1->execMessage(message);
  else {
    GuiDbComponentDialog* w2 = qobject_cast<GuiDbComponentDialog*>( m_widget );
    if ( w2 ) w2->execMessage(message);
    else {
      GuiDbComponentMainWindow* w3 = qobject_cast<GuiDbComponentMainWindow*>( m_widget );
      if ( w3 ) w3->execMessage(message);
    }
  }
}
