/*  -*- c++ -*-  (for Emacs)
 *
 *  strokeseditor.h
 *  Digest
 * 
 *  Created by Aidan Lane on Mon Jun 27 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STROKESEDITOR_H
#define STROKESEDITOR_H


#include "strokesviewer.h"

#include <QTime>
#include <QTimer>


class StrokesEditor : public StrokesViewer {

  Q_OBJECT
  Q_PROPERTY( bool autoClear READ autoClear WRITE setAutoClear )
  Q_PROPERTY( bool readOnly READ isReadOnly WRITE setReadOnly )
  Q_PROPERTY( bool recordHiRes READ recordHiRes WRITE setRecordHiRes )
  Q_PROPERTY( double multiStrokeTimeout READ multiStrokeTimeout \
	      WRITE setMultiStrokeTimeout )

public:
  enum State { EmptyState, StartedState, FinishedState };

  StrokesEditor( QWidget* parent = 0 );
  StrokesEditor( const StrokeList& strokes, QWidget* parent = 0,
		 bool readOnly = false );

  State  state() const;
  bool   autoClear() const;
  bool   isModified() const;
  bool   isReadOnly() const;
  bool   isStrokeBeginDrawn() const;
  bool   recordHiRes() const;
  double multiStrokeTimeout() const;


signals:
  void recordHiResToggled( bool enabled );
  void multiStrokeTimeoutChanged( double timeout );
  void strokingAboutToStart();
  void strokingStarted();
  void strokingFinished( const StrokeList& strokes );


public slots:
  virtual void setAutoClear( bool autoClear );
  virtual void setModified( bool modified );
  virtual void setReadOnly( bool readOnly );
  virtual void setRecordHiRes( bool enable );
  virtual void setStrokes( const StrokeList& strokes, bool updateWidget = true );
  virtual void setMultiStrokeTimeout( double timeout );

  void stopMultiStrokeTimoutTimer();


private slots:
  virtual void onMultiStrokeTimedout();


protected:
  virtual void beginNewStroke( StrokePoint pt );
  virtual void addPointToStroke( const StrokePoint& pt );
  virtual void endStroke();

  virtual void mousePressEvent( QMouseEvent* event );
  virtual void mouseMoveEvent( QMouseEvent* event );
  virtual void mouseReleaseEvent( QMouseEvent* event );
  virtual void tabletEvent( QTabletEvent* event );


private:
  void init();
  void restartMultiStrokeTimoutTimer();

  State   m_state;
  bool    m_autoClear;
  bool    m_modified;
  bool    m_readOnly;
  bool    m_strokeBeginDrawn;
  bool    m_recordHiRes;
  Stroke  m_currentStroke;
  QTime   m_currentMultiStrokeTime;
  double  m_multiStrokeTimeout;
  QTimer* m_multiStrokeTimeoutTimer;
};


#endif  // ! STROKESEDITOR_H
