/* 
 *  strokespainterpath.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jul 7 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "strokespainterpath.h"

#include "Gesture/strokelist.h"


void StrokesPainterPath::addStroke( const Stroke& stroke )
{ 
  if ( stroke.isEmpty() ) return;

  /* NOTE:
   * We MOVE TO the first point and the continually draw a LINE TO the
   * following point. Using the following the two-step process, we eliminate
   * the need to continually check if the current point is the first point.
   * Also, the 2nd step is obviously dependant on the 1st.
   */

  // 1st step - MOVE TO
  const StrokePoint& pt = stroke.first(); // ASSUMES points.isEmpty()==0
  moveTo( pt );
  // ensure that single-point strokes are visible
  addEllipse( pt.x(), pt.y(), m_endPointWidth, m_endPointWidth );

  // 2nd step - LINE TO
  QListIterator<StrokePoint> it( stroke );
  it.next(); // IMPORTANT! We've already visited the first point!
  while ( it.hasNext() ) lineTo( it.next() );
}


void StrokesPainterPath::addStrokes( const StrokeList& strokes )
{
  foreach( const Stroke& s, strokes )
    addStroke( s );
}
