/*  -*- c++ -*-  (for Emacs)
 *
 *  strokespainterpath.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jul 7 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STROKESPAINTERPATH_H
#define STROKESPAINTERPATH_H


#include <QPainterPath>

class Stroke;
class StrokeList;


class StrokesPainterPath : public QPainterPath {

 public:
  StrokesPainterPath() : m_endPointWidth(0.5) {}
  StrokesPainterPath( const QPointF& startPoint )
    : QPainterPath(startPoint), m_endPointWidth(0.5) {}
  StrokesPainterPath( const QPainterPath& other )
    : QPainterPath(other), m_endPointWidth(0.5) {}
  StrokesPainterPath( const StrokesPainterPath& other )
    : QPainterPath(other), m_endPointWidth(0.5)  {}


  /*!
   * Defaults to 0.5
   *
   * See setStrokeEndPointWidth().
   */
  float strokeEndPointWidth() const { return m_endPointWidth; }

  /*!
   * Defaults to 0.5
   *
   * Setting this to a value larger than 0.0 ensures that single-point strokes
   * are visible.
   * 
   * This will only affect future calls to addStrokes.
   */
  void setStrokeEndPointWidth( float width ) { m_endPointWidth = width; }


  void addStroke( const Stroke& stroke );
  void addStrokes( const StrokeList& strokes );


private:
  float m_endPointWidth;
};


#endif  // ! STROKESPAINTERPATH_H
