/*  -*- c++ -*-  (for Emacs)
 *
 *  strokesviewer.h
 *  Digest
 * 
 *  Created by Aidan Lane on Mon Jun 27 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STROKESVIEWER_H
#define STROKESVIEWER_H


#include <QWidget>

#include <QBrush>
#include <QPainterPath>
#include <QPen>
#include <QTime>

#include "Gesture/strokelist.h"
#include "DigestGuiCore/strokespainterpath.h"


class StrokesViewer : public QWidget {

  Q_OBJECT

public:
  StrokesViewer( QWidget* parent = 0 );
  StrokesViewer( const StrokeList& strokes, QWidget* parent = 0 );
  virtual ~StrokesViewer() {}

  const StrokeList& strokes() const { return m_strokes; }
  virtual void setStrokes( const StrokeList& strokes, bool updateWidget = true );

  const QPen& pen() const { return m_pen; }
  virtual void setPen( const QPen& pen, bool updateWidget = true );

  const QBrush& backgroundBrush() const { return m_backgroundBrush; }
  virtual void setBackgroundBrush( const QBrush& brush, bool updateWidget = true );

  const QPen& gridPen() const { return m_gridPen; }
  virtual void setGridPen( const QPen& pen, bool updateWidget= true );

  bool isAnimating() const { return animTimerId; } // !=0 == in animation


signals:
  void animationStarted();
  void animationStopped();


public slots:
  virtual void animate();
  virtual void stopAnimation();


protected:
  StrokeList& strokesRef() { return m_strokes; }
  StrokesPainterPath& pathRef() { return m_path; }

  virtual void paintEvent( QPaintEvent* event );
  virtual void timerEvent( QTimerEvent* event );


private:
  void init();

  StrokeList          m_strokes;
  StrokesPainterPath  m_path;

  QPen         m_pen;
  QBrush       m_backgroundBrush;
  QPen         m_gridPen;

  int          animTimerId;
  int          animStrokeIndex;
  int          animStrokePointIndex;
  QTime        animStrokeTime;
  StrokePoint  animQueuedPoint;
  bool         animQueuedPointWaiting;
};


#endif  // ! STROKESVIEWER_H
