/*  -*- c++ -*-  (for Emacs)
 *
 *  experimentassistant.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Nov 3 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef EXPERIMENTASSISTANT_H
#define EXPERIMENTASSISTANT_H


#include "DigestGuiCore/guicomponentwidgets.h"

#include <QList>

#include <jni.h>

#include "ui_experimentassistantform.h"

class QStandardItemModel;

class CategoryItemModel;
class DigestDbController;
class GestureQueryModel;


class ExperimentAssistant : public GuiDbComponentDialog {

  Q_OBJECT

  enum Step { Introduction,
	      SelectRecognisers,
	      SelectGestures,
	      FinalDetails,
	      ConfirmDetails,
	      PerformingExperiments,
	      Finished,
	      Closed };

public:
  ExperimentAssistant( DigestDbController* controller,
		       JavaVM* jvm,
		       QWidget* parent = 0, Qt::WindowFlags flags = 0 );


protected:
  void resetEvent( VEvent* );
  void experimentsEvent( VExperimentsEvent* );


private slots:
  void on_goBackButton_clicked();
  void on_continueButton_clicked();

  void gotoStep( ExperimentAssistant::Step step );
  void reflectCurrentStep();

  void gatherDetails();
  void beginExperiments();

  void onCategoryModelDataChanged();


private:
  void initWidgets();
  static void initStaticStrs();

  QString detailsAsHtml() const;

  JavaVM* m_jvm;

  Ui::ExperimentAssistantForm ui;
  int m_currentStep;

  CategoryItemModel*   m_categoryModel;
  GestureQueryModel*   m_gestureModel;
  QStandardItemModel*  m_dummyModel;

  QString m_gestureQuery;

  // Details:
  QList<int>  m_recogniserIds;
  QString     m_labelStr;
  QString     m_notesStr;
  QList<int>  m_gestureIds;

  QHash<int, int> m_recogToExper;
};


#endif  // ! EXPERIMENTASSISTANT_H
