/*  -*- c++ -*-  (for Emacs)
 *
 *  experimentbrowser.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Nov 3 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef EXPERIMENTBROWSER_H
#define EXPERIMENTBROWSER_H


#include "DigestGuiCore/guicomponentwidgets.h"

#include <jni.h>

#include "ui_experimentbrowserform.h"


class QItemSelection;
class QItemSelectionModel;
class QSqlQueryModel;
class QStandardItemModel;

class SettingsController;


class ExperimentBrowser : public GuiDbComponentDialog {

  Q_OBJECT

public:
  ExperimentBrowser( DigestDbController* digestDbController,
		     SettingsController* settingsController,
		     JavaVM* jvm,
		     QWidget* parent = 0, Qt::WindowFlags flags = 0 );
  ~ExperimentBrowser();


public slots:
  void refreshExperimentsModel();


protected:
  void showEvent( QShowEvent* );

  void resetEvent( VEvent* );
  void experimentsEvent( VExperimentsEvent* );


private slots:
  void on_newExperimentButton_clicked();
  void on_removeButton_clicked();
  void on_showGesturesButton_clicked();

  void onSelectionChanged();

  void updateDetailsText();
  void updateResults();


private:
  QString experimentRecordAsHtml( const DExperimentRecord& record ) const;

  SettingsController* m_settingsController;
  JavaVM* m_jvm;

  Ui::ExperimentBrowserForm m_ui;

  QSqlQueryModel* m_experimentsModel;
  QItemSelectionModel* m_selectionModel;

  QSqlQueryModel* m_resultsModel;

  QStandardItemModel* m_dummyModel;
};


#endif  // ! EXPERIMENTBROWSER_H
