/*  -*- c++ -*-  (for Emacs)
 *
 *  gesturebrowser.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Jun 21 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GESTUREBROWSER_H
#define GESTUREBROWSER_H


#include "DigestGuiCore/guicomponentwidgets.h"

#include <QPen>

#include "MvcDigestDb/dgesturerecord.h"

#include "ui_gesturebrowserform.h"

class QAction;
class QActionGroup;
class QItemSelection;
class QItemSelectionModel;
class QMenu;
class QStandardItemModel;

class DigestDbController;
class CategoryItemModel;
class GestureQueryModel;
class SearchWidget;
class SettingsController;


class GestureBrowser : public GuiDbComponentMainWindow {

  Q_OBJECT

public:
  GestureBrowser( DigestDbController* digestDbController,
		  SettingsController* settingsController,
		  QWidget* parent = 0, Qt::WindowFlags flags = 0 );
  ~GestureBrowser();

  bool eventFilter( QObject* watched, QEvent* event );


protected:
  void showEvent( QShowEvent* event );
  void hideEvent( QHideEvent* event );

  void resetEvent( VEvent* );
  void classesEvent( VClassesEvent* );
  void collectionsEvent( VCollectionsEvent* );
  void gesturesEvent( VGesturesEvent* );


public slots:
  void execMessage( const QString& message );


private slots:
  void on_actionTestPad_triggered();
  void on_actionRecognisers_triggered();
  void on_actionExperiments_triggered();
  void on_actionDatabase_triggered();
  void on_addGestureButton_clicked();
  void on_gestureIconZoomMin_clicked();
  void on_gestureIconZoomMax_clicked();
  void on_gestureIconZoomSlider_valueChanged( int );
  void on_playAndStopButton_clicked();
  void on_clearButton_clicked();
  void on_duplicateButton_clicked();
  void on_editAndDoneButton_clicked();

  void onGestureModelThumbnailSizeChanged( const QSize& size );

  void beginSearch( const QString& text );
  void endSearch();

  void addNewClass();
  void addNewCollection();

  void splitCollection();

  void removeSelectedCategories();
  void removeSelectedGestures();

  void onClassActionTriggered( QAction* action );
  void onCollectionActionTriggered( QAction* action );

  void animationStateChanged();
  void onCategorySelectionChanged();
  void onGestureSelectionChanged();
  void updateNumGesturesLabel();
  void updateInfoTextBrowser();

  bool setCurrentGesture( int id );
  bool setEditCurrentGesture( bool edit );


private:
  void initToolBar();

  bool updateCurrentGestureFromUi();

  void submitEverything();
  void submitCurrentGesture();

  void refreshAddRemoveClassesMenu();
  void refreshAddRemoveCollectionsMenu();

  QString gestureFieldsAsHtml( const DGestureRecord& g ) const;
  QString gestureDateAsHtml( const QDate& date ) const;

  Ui::GestureBrowserForm m_ui;

  QString m_gestureQueryStr;

  SettingsController* m_settingsController;

  CategoryItemModel*   m_categoryModel;
  QItemSelectionModel* m_categorySelectionModel;

  GestureQueryModel*   m_gestureModel;
  QItemSelectionModel* m_gestureSelectionModel;

  QStandardItemModel*  m_dummyModel;

  QAction*        m_splitCollectionAction;

  DGestureRecord  m_currentGesture;
  bool            m_currentGestureMiscModified;
  bool            m_gestureSelected;
  bool            m_gestureEditing;

  QAction*        m_addGestureAction;

  SearchWidget*   m_searchWidget;
  QMenu*          m_searchMenu;
  QActionGroup*   m_searchTypeActionGroup;
  QAction*        m_searchAllAction;
  QAction*        m_searchIdsAction;
  QAction*        m_searchLabelsAction;
  QAction*        m_searchDatesAction;
  QAction*        m_searchNotesAction;
  QAction*        m_searchClassesAction;
  QAction*        m_searchCollectionsAction;
  QAction*        m_sqlWhereAction;

  QPen    m_editPen;
  QPen    m_viewPen;
  QBrush  m_editBackgroundBrush;
  QBrush  m_viewBackgroundBrush;

  QMenu*    m_addRemoveClassesMenu;
  QMenu*    m_addRemoveCollectionsMenu;
  QAction*  m_newClassAction;            // lives in m_addRemoveClassesMenu
  QAction*  m_noClassesPseudoAction;     // ditto.
  QAction*  m_newCollectionAction;       // lives in m_addRemoveCollectionsMenu
  QAction*  m_noCollectionsPseudoAction; // ditto.
  QActionGroup*  m_classesActionGroup;
  QActionGroup*  m_collectionsActionGroup;
};


#endif  // ! GESTUREBROWSER_H
