/*  -*- c++ -*-  (for Emacs)
 *
 *  gesturebrowsercomponent.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Aug 02 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "gesturebrowsercomponent.h"

#include <QByteArray>

#include "MvcDigestDb/digestdbcontroller.h"

#include "gesturebrowser.h"


/*
 * WARNING!!!
 * Keep this constructor in this separate (.cpp) implementation file.
 * This allows us to keep GestureBrowser's header file out of our header,
 * which ensures that when GestureBrowser's header is (or any other headers
 * included by it are) modified, this library's ABI won't be broken.
 */
GestureBrowserComponent
::GestureBrowserComponent( DigestDbController* digestDbController,
			   SettingsController* settingsController,
			   JavaVM* jvm, QWidget* parent,
			   Qt::WindowFlags flags )
  : StdGuiDbComponent(new GestureBrowser(digestDbController,
					 settingsController,
					 parent, flags),
		      digestDbController, jvm, parent, flags)
{
}


const QByteArray& GestureBrowserComponent::classKey() {
  static QByteArray key( "GestureBrowser" );
  return key;
}
