/*  -*- c++ -*-  (for Emacs)
 *
 *  splitcollectiondialog.h
 *  Digest
 * 
 *  Created by Aidan Lane on Sun Apr 23 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef SPLITCOLLECTIONDIALOG_H
#define SPLITCOLLECTIONDIALOG_H


#include <QDialog>

#include <QHash>
#include <QList>

#include <MvcDigestDb/abstractdigestdbview.h>

#include "ui_splitcollectionform.h"

class DigestDbController;


class SplitCollectionDialog : public QDialog, public AbstractDigestDbView {

  Q_OBJECT

public:
  SplitCollectionDialog( int collectionId,
			 DigestDbController* controller,
			 QWidget * parent = 0, Qt::WFlags f = 0 );


public slots:
  void accept();


protected:
  DEFINE_CUSTOM_VIEWEVENT_HANDLER
  void resetEvent( VEvent* );
  void collectionsEvent( VCollectionsEvent* );


private slots:
  void on_trainPercentSpinBox_valueChanged( double value );
  void on_trainCountSpinBox_valueChanged( int value );
  void on_testPercentSpinBox_valueChanged( double value );
  void on_testCountSpinBox_valueChanged( int value );


private:
  Ui::SplitCollectionForm  m_ui;

  int      m_srcCollectionId;
  int      m_trainCollectionId;
  int      m_testCollectionId;

  QString  c_label;
  int      c_totalGestures;
  QHash< int, QList<int> > c_classToGestures; // vs. QMultiHash - easy to get whole list
};


#endif  // ! SPLITCOLLECTIONDIALOG_H
