### Warning: this will only work with Makefile builds

TEMPLATE = app
LANGUAGE = C++

# On Mac OS X and Windows, use "GestureLab" as the target name.
# However, on UNIX systems other than Mac OS X, use "gesturelab" (i.e. lowercase),
# as it`s more often typed in via a terminal/console rather than double-clicked.
unix:!macx {
	TARGET = gesturelab
} else {
	TARGET = GestureLab
}
DESTDIR = ../../bin/ ### Note: the "bin" directory will be created automatically


### INCLUDE THE CONFIG
include( ../../config.pri ) ### Warning! we must set TEMPLATE and TARGET before we do this

CONFIG	+= qt uic resources warn_on  ### Warning! release/debug is set by config.pri
QT      += sql xml

# Define useful names and paths
## WARNING: DESTDIR_TARGET does not seem to work...
macx {
        APP_CONTENTS_DIR     = $${DESTDIR}/$${TARGET}.app/Contents
	COMPLETE_TARGET_NAME = $${APP_CONTENTS_DIR}/MacOS/$${TARGET}
        APP_RES_DIR          = $${APP_CONTENTS_DIR}/Resources
	APP_LIBS_DIR         = $${APP_CONTENTS_DIR}/Resources
} else {
	COMPLETE_TARGET_NAME = $${DESTDIR}/$${TARGET}
}

macx:RC_FILE = mac/GestureLab.icns
macx:QMAKE_POST_LINK = sh postlinkscript_mac.sh

unix {
  UI_DIR = .ui
  MOC_DIR = .moc
  OBJECTS_DIR = .obj
}


# LIBRARY: Java Virtual Machine
# TODO: make this system independant!
INCLUDEPATH += /System/Library/Frameworks/JavaVM.framework/Headers
LIBS += -framework JavaVM


# LIBRARY HEADER FILES
DEPENDPATH += ../include
INCLUDEPATH += ../include


# LIBRARY: Gesture
PRE_TARGETDEPS += ../Gesture/libGesture.dylib
LIBS += ../Gesture/libGesture.dylib
include( ../include/Gesture/paths.pri )

# LIBRARY: MvcCore
PRE_TARGETDEPS += ../MvcCore/libMvcCore.dylib
LIBS += ../MvcCore/libMvcCore.dylib
include( ../include/MvcCore/paths.pri )

# LIBRARY: MvcDigestDb
PRE_TARGETDEPS += ../MvcDigestDb/libMvcDigestDb.dylib
LIBS += ../MvcDigestDb/libMvcDigestDb.dylib
include( ../include/MvcDigestDb/paths.pri )

# LIBRARY: MvcSettings
PRE_TARGETDEPS += ../MvcSettings/libMvcSettings.dylib
LIBS += ../MvcSettings/libMvcSettings.dylib
include( ../include/MvcSettings/paths.pri )

# LIBRARY: WidgetPack
PRE_TARGETDEPS += ../WidgetPack/libWidgetPack.dylib
LIBS += ../WidgetPack/libWidgetPack.dylib
include( ../include/WidgetPack/paths.pri )

# LIBRARY: DigestGuiCore
PRE_TARGETDEPS += ../DigestGuiCore/libDigestGuiCore.dylib
LIBS += ../DigestGuiCore/libDigestGuiCore.dylib
include( ../include/DigestGuiCore/paths.pri )

# LIBRARY: GestureRecognition
PRE_TARGETDEPS += ../GestureRecognition/libGestureRecognition.dylib
LIBS += ../GestureRecognition/libGestureRecognition.dylib
include( ../include/GestureRecognition/paths.pri )

# LIBRARY: ExperimentAssistant
PRE_TARGETDEPS += ../ExperimentAssistant/libExperimentAssistant.dylib
LIBS += ../ExperimentAssistant/libExperimentAssistant.dylib
include( ../include/ExperimentAssistant/paths.pri )

# LIBRARY: ExperimentBrowser
PRE_TARGETDEPS += ../ExperimentBrowser/libExperimentBrowser.dylib
LIBS += ../ExperimentBrowser/libExperimentBrowser.dylib
include( ../include/ExperimentBrowser/paths.pri )

# LIBRARY: GestureBrowser
PRE_TARGETDEPS += ../GestureBrowser/libGestureBrowser.dylib
LIBS += ../GestureBrowser/libGestureBrowser.dylib
include( ../include/GestureBrowser/paths.pri )

# LIBRARY: RecogniserBrowser
PRE_TARGETDEPS += ../RecogniserBrowser/libRecogniserBrowser.dylib
LIBS += ../RecogniserBrowser/libRecogniserBrowser.dylib
include( ../include/RecogniserBrowser/paths.pri )

# LIBRARY: RecogniserTestPad
PRE_TARGETDEPS += ../RecogniserTestPad/libRecogniserTestPad.dylib
LIBS += ../RecogniserTestPad/libRecogniserTestPad.dylib
include( ../include/RecogniserTestPad/paths.pri )

# LIBRARY: SqlBrowser
PRE_TARGETDEPS += ../SqlBrowser/libSqlBrowser.dylib
LIBS += ../SqlBrowser/libSqlBrowser.dylib
include( ../include/SqlBrowser/paths.pri )

# LIBRARY: TrainingAssistant
PRE_TARGETDEPS += ../TrainingAssistant/libTrainingAssistant.dylib
LIBS += ../TrainingAssistant/libTrainingAssistant.dylib
include( ../include/TrainingAssistant/paths.pri )


DEPENDPATH  += . \
               .. \
               views \
               reusable/mdi
INCLUDEPATH += . \
               .. \
               views \
               reusable/mdi

HEADERS += ../digestsettings.h \
           ../sharedmacros.h \
           digest.h \
           actionmanager.h \
           gesturelabapplication.h \
           views/connectiondialog.h \
           views/gesturelabprefsdialog.h

SOURCES += actionmanager.cpp \
           gesturelabapplication.cpp \
           main.cpp \
           views/connectiondialog.cpp \
           views/gesturelabprefsdialog.cpp

FORMS += aboutboxform.ui \
         views/connectiondialogform.ui \
         views/gesturelabprefsdialogform.ui

RESOURCES += GestureLab.qrc
