// BASED ON: qdesigner_actions.cpp in qt-mac-opensource-4.0.0-b2-snapshot-20050318, located in the /tools/designer/src/designer/ sub-dir of Qt.
//           Imported on Wed Mar 30 2005 by Aidan Lane.
//           Modifications Copyright (c) CEMA, Monash University. All rights reserved.
/****************************************************************************
 **
 ** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
 **
 ** This file is part of the designer application of the Qt Toolkit.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
 **   information about Qt Commercial License Agreements.
 ** See http://www.trolltech.com/gpl/ for GPL licensing information.
 **
 ** Contact info@trolltech.com if any conditions of this licensing are
 ** not clear to you.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

#include "actionmanager.h"

#include <QAction>
#include <QActionGroup>
#include <QSignalMapper>

#include "gesturelabapplication.h"

/* 
 * The following strings are used more than once, so macros have been used to
 * ensure  consistency and assist when modifications are required.
 */
#define SHOW_STR                tr("Show ")
#define HIDE_STR                tr("Hide ")
#define TURN_STR                tr("Turn ")
#define ON_STR                  tr(" On")
#define OFF_STR                 tr(" Off")
#define INDENT_MENU_ITEM_STR    tr("   ")

// TODO: check which symbol is best for which platform (other than Mac OS X)
#ifdef Q_WS_MAC // _IS_ Mac
#define ELLIPSIS_STR  QChar(0x2026)  // the single "..." character - used on Mac OS X
#else
#define ELLIPSIS_STR  "..."
#endif


static ActionManager* mdiActionManagerInstance = 0;


ActionManager::ActionManager( GestureLabApplication* diagramManager )
  : QObject(diagramManager),
    m_diagramManager(diagramManager),
    m_signalMapper(0)
{
  QAction* sep = 0;

  // TODO: implement a proper singleton interface!
  Q_ASSERT( mdiActionManagerInstance == 0
	    && "There may only be one instance of ActionManager" );
  mdiActionManagerInstance = this;

  Q_ASSERT( ! m_diagramManager.isNull() );

  m_signalMapper = new QSignalMapper( this );
  connect( m_signalMapper,
	   SIGNAL(mapped(const QString&)),
	   SIGNAL(request(const QString&)) );

  m_fileActions = new QActionGroup( this );
  m_fileActions->setExclusive( false );

  m_editActions = new QActionGroup( this );
  m_editActions->setExclusive( false );

  m_windowActions = new QActionGroup( this );
  m_windowActions->setExclusive( false );

  m_helpActions = new QActionGroup( this );
  m_helpActions->setExclusive( false );


  /*
   * File actions
   */
  m_newRecogniserAction = new QAction( tr("New &Recogniser"), m_fileActions );
  m_newRecogniserAction->setShortcut( Qt::CTRL + Qt::Key_N );
  m_signalMapper->setMapping( m_newRecogniserAction, "new TrainingAssistant" );
  connect( m_newRecogniserAction, SIGNAL(triggered()), m_signalMapper, SLOT(map()) );

  m_newExperimentAction = new QAction( tr("New &Experiment"), m_fileActions );
  m_newExperimentAction->setShortcut( Qt::ALT + Qt::CTRL + Qt::Key_N );
  m_signalMapper->setMapping( m_newExperimentAction, "new ExperimentAssistant" );
  connect( m_newExperimentAction, SIGNAL(triggered()), m_signalMapper, SLOT(map()) );

  sep = new QAction( m_fileActions );
  sep->setSeparator( true );

  // Warning! Don't add this action to m_fileActions yet. We add it further down if not on Mac OS X.
  m_closeWindowAction = new QAction( tr("&Close"), this );
  m_closeWindowAction->setShortcut( tr("CTRL+W") );
  connect(m_closeWindowAction, SIGNAL(triggered()), m_diagramManager, SLOT(closeActiveWindow()));
#ifdef Q_WS_MAC // _IS_ Mac
  m_fileActions->addAction( m_closeWindowAction ); // *** on Mac OS X, place the Close action here
#endif

#ifndef Q_WS_MAC // _NOT_ Mac
  sep = new QAction( m_fileActions ); // separate the Close action from the save actions on these systems
  sep->setSeparator( true );
  m_fileActions->addAction( m_closeWindowAction ); // *** on systems OTHER THAN Mac OS X, place the Close
 action here
#endif

  // On Mac OS X, the quit item is moved to the appliction menu, so this separator is redundant.
#ifndef Q_WS_MAC // _NOT_ Mac
  sep = new QAction( m_fileActions );
  sep->setSeparator( true );
#endif

  // We use the string "Exit", as that is what is known as on Windows and Linux.
  // On Mac OS X, Qt will remove this anyway and add "Quit Nodal" to the application menu.
  m_appQuitAction = new QAction( tr("E&xit"), m_fileActions );
  connect( m_appQuitAction, SIGNAL(triggered()), m_diagramManager, SLOT(appQuit()) );


  /*
   * Edit actions
   */
  m_undoAction = new QAction( tr("&Undo"), m_editActions );
  m_undoAction->setShortcut( tr("CTRL+Z") );
  m_undoAction->setEnabled( false );

  m_redoAction = new QAction( tr("&Redo"), m_editActions );
  m_redoAction->setShortcut( tr("CTRL+SHIFT+Z") );
  m_redoAction->setEnabled( false );

  sep = new QAction( m_editActions );
  sep->setSeparator( true );

  m_cutAction = new QAction( tr("Cu&t"), m_editActions );
  m_cutAction->setEnabled( false );

  m_copyAction = new QAction( tr("&Copy"), m_editActions );
  m_copyAction->setEnabled( false );

  m_pasteAction = new QAction( tr("&Paste"), m_editActions );
  m_pasteAction->setEnabled( false );

  m_deleteAction = new QAction( tr("&Delete"), m_editActions );
  m_deleteAction->setEnabled( false );

  m_selectAllAction = new QAction(tr("Select &All"), m_editActions );

  // On Mac OS X, the prefs item is moved to the appliction menu, so this separator is redundant.
#ifndef Q_WS_MAC // _NOT_ Mac
  sep = new QAction( m_editActions );
  sep->setSeparator( true );
#endif

  // Qt will automatically move this to the applications menu as "Preferences...".
  m_appPrefsAction = new QAction( tr("&Preferences") + ELLIPSIS_STR , m_editActions );
  connect( m_appPrefsAction, SIGNAL(triggered()), m_diagramManager, SLOT(showAppPrefs()) );
  

  /*
   * Window actions
   */
  m_minimizeWindowAction = new QAction(tr("&Minimize"), this);
  m_minimizeWindowAction->setShortcut(tr("CTRL+M"));
  m_windowActions->addAction(m_minimizeWindowAction);
  connect(m_minimizeWindowAction, SIGNAL(triggered()), this, SLOT(minimizeWindow()));

  m_zoomWindowAction = new QAction(tr("&Zoom"), this);
  m_windowActions->addAction(m_zoomWindowAction);
  connect(m_zoomWindowAction, SIGNAL(triggered()), this, SLOT(zoomWindow()));

  sep = new QAction( m_windowActions );
  sep->setSeparator( true );

  m_showGestureBrowserAction = new QAction( tr("&Gesture Browser"), m_windowActions );
  m_showGestureBrowserAction->setShortcut( Qt::CTRL + Qt::Key_G );
  m_signalMapper->setMapping( m_showGestureBrowserAction, "show GestureBrowser" );
  connect( m_showGestureBrowserAction, SIGNAL(triggered()), m_signalMapper, SLOT(map()) );

  m_showRecogniserTestPadAction = new QAction( tr("Recogniser &TestPad"), m_windowActions );
  m_showRecogniserTestPadAction->setShortcut( Qt::CTRL + Qt::Key_T );
  m_signalMapper->setMapping( m_showRecogniserTestPadAction, "show RecogniserTestPad" );
  connect( m_showRecogniserTestPadAction, SIGNAL(triggered()), m_signalMapper, SLOT(map()) );

  m_showRecogniserBrowserAction = new QAction( tr("&Recogniser Browser"), m_windowActions );
  m_showRecogniserBrowserAction->setShortcut( Qt::CTRL + Qt::Key_R );
  m_signalMapper->setMapping( m_showRecogniserBrowserAction, "show RecogniserBrowser" );
  connect( m_showRecogniserBrowserAction, SIGNAL(triggered()), m_signalMapper, SLOT(map()) );

  m_showExperimentBrowserAction = new QAction( tr("&Experiment Browser"), m_windowActions );
  m_showExperimentBrowserAction->setShortcut( Qt::CTRL + Qt::Key_E );
  m_signalMapper->setMapping( m_showExperimentBrowserAction, "show ExperimentBrowser" );
  connect( m_showExperimentBrowserAction, SIGNAL(triggered()), m_signalMapper, SLOT(map()) );

  m_showSqlBrowserAction = new QAction( tr("SQL &Database Browser"), m_windowActions );
  m_showSqlBrowserAction->setShortcut( Qt::CTRL + Qt::Key_D ); // Key_S is used for Save
  m_signalMapper->setMapping( m_showSqlBrowserAction, "show SqlBrowser" );
  connect( m_showSqlBrowserAction, SIGNAL(triggered()), m_signalMapper, SLOT(map()) );

  sep = new QAction( m_windowActions );
  sep->setSeparator( true );

  m_bringAllToFrontAction = new QAction(tr("Bring All to Front"), this);
  connect(m_bringAllToFrontAction, SIGNAL(triggered()), this, SLOT(bringAllToFront()));
  m_windowActions->addAction(m_bringAllToFrontAction);


  /*
   * Help actions
   */
  m_appHelpAction = new QAction( tr("Nodal &Help"), m_helpActions );// FIXME: use global name, vs. Nodal !
  connect(m_appHelpAction, SIGNAL(triggered()), m_diagramManager, SLOT(showAppHelp()));
#ifdef Q_WS_MAC
  m_appHelpAction->setShortcut(Qt::CTRL + Qt::Key_Question);
#else
  m_appHelpAction->setShortcut(Qt::Key_F1);
#endif

  // On Mac OS X, the about items are merged in so this separator is redundant.
#ifndef Q_WS_MAC
  sep = new QAction( m_helpActions );
  sep->setSeparator( true );
#endif
  m_appAboutAction = new QAction( tr("&About Nodal"), m_helpActions ); // FIXME: use global name, v.s. Nodal !
  connect(m_appAboutAction, SIGNAL(triggered()), m_diagramManager, SLOT(showAppAbout()));


  // Finally, fix the shortcut context of the actions
  fixActionContext();
}


ActionManager::~ActionManager()
{
  Q_ASSERT( mdiActionManagerInstance != 0 ); // safety check
  mdiActionManagerInstance = 0;
}


ActionManager* ActionManager::instance() {
  return mdiActionManagerInstance;
}


GestureLabApplication* ActionManager::diagramManager() const {
  return m_diagramManager;
}


void ActionManager::fixActionContext()
{
  QList<QAction*> actions;
  actions += m_fileActions->actions();
  actions += m_editActions->actions();
  actions += m_windowActions->actions();
  actions += m_helpActions->actions();

  foreach ( QAction* a, actions ) {
    a->setShortcutContext( Qt::ApplicationShortcut );
  }
}


/*!
 * Minimizes the active diagram window.
 *
 * This is the same as clicking the minimize button on the window itself.
 *
 * The diagram window will no longer be active, as a minimized diagram window
 * can't be considered "active".
 *
 * Asserts that there is an active diagram window.
 * This is because this method is only meaningful when there is an active window.
 * Therefore, the user should not be allowed to trigger it when there isn't one.
 */
void ActionManager::minimizeWindow()
{
  /*
  Q_ASSERT( ! m_activeDiagramWindow.isNull() );
  m_activeDiagramWindow->showMinimized();
  */
}


/*!
 * If the active diagram window is not maximized (i.e. in "normal" state) then
 * it will be maximized. Otherwise, if it is maximized, then it will be restored
 * to its previous dimensions that it had when it wasn't maximized.
 *
 * This is the same as clicking the zoom button on the window itself.
 *
 * Remember that a diagram window that is currently MINImized can't be
 * considered "active".
 *
 * Asserts that there is an active diagram window.
 * This is because this method is only meaningful when there is an active window.
 * Therefore, the user should not be allowed to trigger it when there isn't one.
 */
void ActionManager::zoomWindow()
{
  /*
  Q_ASSERT( ! m_activeDiagramWindow.isNull() );
  // TODO: check and clean-up:
  if ( m_activeDiagramWindow->isMaximized() ) m_activeDiagramWindow->showNormal();
  else if ( m_activeDiagramWindow->isVisible() ) m_activeDiagramWindow->showMaximized(); // FIXME
  */
}


/*!
 * Raise all child windows to the front.
 * This will only affect visible windows (so minmized windows will be left as they are).
 *
 * Asserts that there is an active diagram window.
 * This is because this method is only meaningful when there is an active window.
 * Therefore, the user should not be allowed to trigger it when there isn't one.
 */
void ActionManager::bringAllToFront()
{
  //  foreach ( MDIChildBase* c, m_diagramManager->childWindows() )
  //  c->widgetPtr()->raise();
}

void ActionManager::showAppHelp()
{
 /*
    if (!m_assistantClient)
    m_assistantClient
    = new QAssistantClient(QLibraryInfo::location(QLibraryInfo::BinariesPath), this);
    m_assistantClient->showPage(QLibraryInfo::location(QLibraryInfo::DocumentationPath)
    + "/html/" + url);
  */
  //    showHelp("designer-manual.html");
}
