// -*- c++ -*-  (for Emacs)

// BASED ON: qdesigner_actions.h in qt-mac-opensource-4.0.0-b2-snapshot-20050318, located in the /tools/designer/src/designer/ sub-dir of Qt.
//           Imported on Wed Mar 30 2005 by Aidan Lane.
//           Modifications Copyright (c) CEMA, Monash University. All rights reserved.
/****************************************************************************
 **
 ** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
 **
 ** This file is part of the designer application of the Qt Toolkit.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
 **   information about Qt Commercial License Agreements.
 ** See http://www.trolltech.com/gpl/ for GPL licensing information.
 **
 ** Contact info@trolltech.com if any conditions of this licensing are
 ** not clear to you.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/


#ifndef ACTIONMANAGER_H
#define ACTIONMANAGER_H

#include <QObject>
#include <QPointer>


class QAction;
class QActionGroup;
class QSignalMapper;

class GestureLabApplication;


/*!
 * Manages the actions for the entire app.
 *
 * Uses signals'n'slots to communicate with GestureLabApplication and its
 * MDIDiagramWindows, telling them what to do when an action is triggered.
 *
 * WARNING! There may only be one instance of ActionManager.
 *          Because of this, other objects can use it without having to be told
 *          of its address explicitly.
 */

class ActionManager: public QObject {

  Q_OBJECT
 
public:
  ActionManager( GestureLabApplication* diagramManager );
  virtual ~ActionManager();

  static ActionManager* instance();

  GestureLabApplication* diagramManager() const;

  QActionGroup* fileActions()   const { return m_fileActions; }
  QActionGroup* editActions()   const { return m_editActions; }
  QActionGroup* windowActions() const { return m_windowActions; }
  QActionGroup* helpActions()   const { return m_helpActions; }

  /*
   * File actions
   */
  QAction* newRecogniserAction() const { return m_newRecogniserAction; }
  QAction* newExperimentAction() const { return m_newExperimentAction; }
  QAction* closeWindowAction()   const { return m_closeWindowAction; }
  QAction* appQuitAction()       const { return m_appQuitAction; }

  /*
   * Edit actions
   */
  QAction* undoAction()      const { return m_undoAction; }
  QAction* redoAction()      const { return m_redoAction; }
  QAction* cutAction()       const { return m_cutAction; }
  QAction* copyAction()      const { return m_copyAction; }
  QAction* pasteAction()     const { return m_pasteAction; }
  QAction* deleteAction()    const { return m_deleteAction; }
  QAction* selectAllAction() const { return m_selectAllAction; }
  QAction* appPrefsAction()  const { return m_appPrefsAction; }

  /*
   * Window actions
   */
  QAction* minimizeWindowAction()         const { return m_minimizeWindowAction; }
  QAction* zoomWindowAction()             const { return m_zoomWindowAction; }
  QAction* showGestureBrowserAction()     const { return m_showGestureBrowserAction; }
  QAction* showRecogniserTestPadAction()  const { return m_showRecogniserTestPadAction; }
  QAction* showRecogniserBrowserAction()  const { return m_showRecogniserBrowserAction; }
  QAction* showExperimentBrowserAction()  const { return m_showExperimentBrowserAction; }
  QAction* showSqlBrowserAction()         const { return m_showSqlBrowserAction; }
  QAction* bringAllToFrontAction()        const { return m_bringAllToFrontAction; }

  /*
   * Help actions
   */
  QAction* appHelpAction()  const { return m_appHelpAction; }
  QAction* appAboutAction() const { return m_appAboutAction; }


signals:
  void request( const QString& message );


protected slots:
  void minimizeWindow();
  void zoomWindow();
  void bringAllToFront();

  void showAppHelp();


private:
  void fixActionContext();

  QPointer<GestureLabApplication> m_diagramManager;

  QSignalMapper* m_signalMapper;

  QActionGroup* m_fileActions;
  QActionGroup* m_editActions;
  QActionGroup* m_windowActions;
  QActionGroup* m_helpActions;

  QAction* m_newRecogniserAction;
  QAction* m_newExperimentAction;
  QAction* m_closeWindowAction;
  QAction* m_appQuitAction;

  QAction* m_undoAction;
  QAction* m_redoAction;
  QAction* m_cutAction;
  QAction* m_copyAction;
  QAction* m_pasteAction;
  QAction* m_deleteAction;
  QAction* m_selectAllAction;
  QAction* m_appPrefsAction;

  QAction* m_minimizeWindowAction;
  QAction* m_zoomWindowAction;
  QAction* m_showGestureBrowserAction;
  QAction* m_showRecogniserTestPadAction;
  QAction* m_showRecogniserBrowserAction;
  QAction* m_showExperimentBrowserAction;
  QAction* m_showSqlBrowserAction;
  QAction* m_bringAllToFrontAction;

  QAction* m_appHelpAction;
  QAction* m_appAboutAction;
};


#endif // ACTIONMANAGER_H
