/*  TODO: re-write header! 
 *  gesturelabapplication.cpp
 *  Nodal
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *  Copyright (c) 2005-2006 CEMA, Monash University. All rights reserved.
 *
 *  Original file:
 *
 *    gesturelabapplication.cpp
 *    EverGreen
 *
 *    Created by Aidan Lane on Mon Jul 19 2004.
 *    Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

//TODO: if we add a grey background in for Windows and Linux, then add the Window menu back for them!

#include "gesturelabapplication.h"

#include <QAction>
#include <QActionGroup>
#include <QDebug> // TODO: remove me
#include <QDesktopWidget>
#include <QDir> // TODO: remove me!
#include <QEventLoop>
#include <QFileDialog>
#include <QFileOpenEvent>
#include <QMenuBar>
#include <QMessageBox>
#include <QProgressDialog>
#include <QSqlQuery>

#include <QPalette> // TODO: remove me!

#ifdef Q_WS_MAC
#include <Carbon/Carbon.h> // mainly for CFBundleCopyBundleURL & CFURLCopyFileSystemPath
#endif

#include "MvcDigestDb/digestdbmodel.h"
#include "MvcDigestDb/digestdbcontroller.h"
#include "MvcSettings/settingsmodel.h"
#include "MvcSettings/settingscontroller.h"
#include "GestureRecognition/featurefactory.h"
#include "GestureRecognition/recogniserfactory.h"
// Components:
#include "ExperimentAssistant/experimentassistantcomponent.h"
#include "ExperimentBrowser/experimentbrowsercomponent.h"
#include "GestureBrowser/gesturebrowsercomponent.h"
#include "RecogniserBrowser/recogniserbrowsercomponent.h"
#include "RecogniserTestPad/recognisertestpadcomponent.h"
#include "SqlBrowser/sqlbrowsercomponent.h"
#include "TrainingAssistant/trainingassistantcomponent.h"

#include "actionmanager.h"
#include "connectiondialog.h"
#include "digestsettings.h"

#include "ui_aboutboxform.h"



GestureLabApplication::GestureLabApplication( int& argc, char** argv )
  : QApplication(argc, argv),
    m_jvm(0),
    m_dbModel(0),
    m_dbController(0),
    m_settingsModel(0),
    m_settingsController(0)
{
  // Note: init() is delayed until the event-loop has begun,
  //       as it may need to call exit().
}


GestureLabApplication::~GestureLabApplication()
{
  /* TODO: INVESTIGATE TO SEE IF THE FOLLOWING IS STILL TRUE!
   * All MVC sets (diagrams, diagram controllers and diagram windows) will
   * automatically be deleted, as the diagram windows will be closed by appQuit().
   * Each close call will itself call our childWindowCloseRequest() method, which
   * looks after all memory de-allocation.
   */

  // The browsers are **NOT** children of us -> they need to be deleted explicitly!
  delete m_experimentBrowserCom;
  delete m_gestureBrowserCom;
  delete m_recogniserBrowserCom;
  delete m_recogniserTestPadCom;
  delete m_sqlBrowserCom;

  /* Ensure that any of the components' final messages are delivered
   * - e.g. changes to settings that have been posted to the settings controller.
   * Note: It may take a few levels of posting and thus processing for the events
   *       to be completely fulfilled.
   */
  while ( hasPendingEvents() )
    processEvents( QEventLoop::ExcludeUserInputEvents
		   | QEventLoop::ExcludeSocketNotifiers );

  Q_ASSERT( m_jvm != 0 );
  jint res = m_jvm->DestroyJavaVM(); // yes, it's an odd way to destroy it!
  if ( res < 0 ) {
    qDebug( "Couldn't destroy the Java VM" );
    exit( 1 ); // TODO: handle me properly
  }

  /* Note: THIS IS EXTREMELY IMPORTANT!!!
   *       If we don't do this, we get intermittent spurts of
   *       "database table is locked Unable to fetch row" from lastError().
   *
   * Also, from the Qt 4.0.0 doc:
   * close() "Closes the database connection, freeing any resources acquired.
   * This will also affect copies of this QSqlDatabase object."
   * and:
   * removeDatabase() "Removes the database connection connectionName from the
   * list of database connections. Warning: There should be no open queries on
   * the database connection when this function is called, otherwise a resource
   * leak will occur."
   */
  m_db.close();
  QSqlDatabase::removeDatabase( m_dbConnectionName );
}


/*!
  Note: init() is delayed until the event-loop has begun,
        as it may need to call exit().
*/
bool GestureLabApplication::event( QEvent* e )
{
  static bool s_initCalled = false;

  // Should get here at launch, at least because of QEvent::ApplicationActivated
  if ( ! s_initCalled ) {
    s_initCalled = true;
    init();
  }

  return QApplication::event( e );
}


/*!
 * Remember that we are not a derivative of QWidget, so we must explictly tell
 * each of a children to be shown if we want them to be so.
 */
// TODO: rememeber settings and only ceate a new diagram if the settings tell it to.
void GestureLabApplication::init()
{
  QProgressDialog progress( tr("Starting..."), "Abort Copy", 0, 3, 0, Qt::SplashScreen );
  progress.setMinimumWidth( 300 );
  progress.setAutoReset( false ); // as we will reshow it and want to keep the progress
  progress.setCancelButton( 0 );  // hide the cancel button
  processEvents( QEventLoop::ExcludeUserInputEvents );

  m_settingsModel = new SettingsModel( Digest::orgName, Digest::appName, this );
  m_settingsController = new SettingsController( m_settingsModel, this );

  progress.setValue( 1 );
  progress.setLabelText( tr("Loading Java Virtual Machine...") );
  processEvents( QEventLoop::ExcludeUserInputEvents ); // call AFTER text change

  initJvm(); // GLOBAL Java virtual machine

  progress.setValue( 2 );  
  progress.setLabelText( tr("Loading plug-ins...") );
  processEvents( QEventLoop::ExcludeUserInputEvents ); // call AFTER text change

  FeatureFactory::loadPlugins( m_jvm );
  RecogniserFactory::loadPlugins( m_jvm );

  progress.setValue( 3 );
  progress.close(); // close it before we show the connection dialog
  processEvents( QEventLoop::ExcludeUserInputEvents );

  if ( !reconnectDatabase() ) return; // needed as appQuit() is returns to caller

  progress.setMaximum( 5 ); // set a new maximum -> show progress box

  progress.setValue( 4 );
  progress.setLabelText( tr("Loading user interface...") );
  processEvents( QEventLoop::ExcludeUserInputEvents );

  setupUi();

  progress.setValue( 5 );
  processEvents( QEventLoop::ExcludeUserInputEvents );
}


void GestureLabApplication::initJvm()
{
  // TODO: cleanup!

  Q_ASSERT( m_jvm == 0 ); // sanity check - shouldn't get here more than once

  // Keep these alive - just in case they need to be accessed later (via pointers)
  static JNIEnv* env;
  static JavaVMInitArgs vm_args;
  static char classPathOption[4096]; // the app's path may be long and we repeat it 3x

  vm_args.version = JNI_VERSION_1_4;

  JNI_GetDefaultJavaVMInitArgs( &vm_args );

  // TODO: support class paths for other OSs!
#ifdef Q_WS_MAC
  CFURLRef    bundleRef = CFBundleCopyBundleURL( CFBundleGetMainBundle() );
  CFStringRef macPath   = CFURLCopyFileSystemPath( bundleRef,
						   kCFURLPOSIXPathStyle );
  const char* macPathPtr
    = CFStringGetCStringPtr( macPath, CFStringGetSystemEncoding() );
  snprintf( classPathOption, 4096,
	    "-Djava.class.path="
	    "%s/Contents/Libraries/"
	    ":%s/Contents/Libraries/GestureRecognition.jar",
	    macPathPtr, macPathPtr );
  CFRelease( bundleRef );
  CFRelease( macPath );
#else
  // TODO: finish me!
  snprintf( classPathOption, 4096,
	    "-Djava.class.path=.:GestureRecognition.jar" );
#endif

  // Append OUR class path to the end of default system class path
  JavaVMOption options[1];
  vm_args.nOptions = 1;
  options[0].optionString = classPathOption;
  //  DOESN'T WORK STILL!!! options[1].optionString = "-Djava.awt.headless=true"; // REQUIRES JAVA 1.4 - TODO: DOC WHY THIS IS SO EXTREAMLY IMPORTANT!!! (WILL CRASH OTHERWISE ON MACOSX)
  vm_args.options = options;
  vm_args.ignoreUnrecognized = JNI_TRUE;

  // Create the Java VM
  jint res = JNI_CreateJavaVM( &m_jvm,(void**)&env, &vm_args );
  if ( res < 0 ) {
    qDebug( "Can't create Java VM" );
    exit( 1 ); // TODO: handle me properly
  }
}


/*!
 * Create the user interface. This should only be called by the constructor.
 *
 * This will make a call to createMenuBar().
 */
void GestureLabApplication::setupUi()
{
  m_actionManager = new ActionManager( this );
  connect( m_actionManager, SIGNAL(request(const QString&)),
	   SLOT(onRequest(const QString&)) );

  createMenuBar();

  /*
   * Create the graphical components
   *
   * Note: These are NOT tool windows, because when they were, they were very
   *       annoying, as switching to another app would hide them (at least on
   *       Mac OS X), they were hidden from Expose on the Mac (same reason as 1st),
   *       you couldn't raise other windows above them, etc.
   */
  m_experimentBrowserCom = new ExperimentBrowserComponent( m_dbController,
							   m_settingsController,
							   m_jvm );
  m_gestureBrowserCom = new GestureBrowserComponent( m_dbController,
						     m_settingsController,
						     m_jvm );
  m_recogniserBrowserCom = new RecogniserBrowserComponent( m_dbController, m_jvm );
  m_recogniserTestPadCom = new RecogniserTestPadComponent( m_dbController,
							   m_settingsController,
							   m_jvm );
  m_sqlBrowserCom = new SqlBrowseComponent( m_dbController, m_jvm );

  m_components.append( m_experimentBrowserCom );
  m_components.append( m_gestureBrowserCom );
  m_components.append( m_recogniserBrowserCom );
  m_components.append( m_recogniserTestPadCom );
  m_components.append( m_sqlBrowserCom );

  connect( m_experimentBrowserCom,
	   SIGNAL(request(const QString&)), SLOT(onRequest(const QString&)) );
  connect( m_gestureBrowserCom,
	   SIGNAL(request(const QString&)), SLOT(onRequest(const QString&)) );
  connect( m_recogniserBrowserCom,
	   SIGNAL(request(const QString&)), SLOT(onRequest(const QString&)) );
  connect( m_recogniserTestPadCom,
	   SIGNAL(request(const QString&)), SLOT(onRequest(const QString&)) );
  connect( m_sqlBrowserCom,
	   SIGNAL(request(const QString&)), SLOT(onRequest(const QString&)) );

  m_experimentBrowserCom->hideRootWidget();
  m_gestureBrowserCom->showRootWidget( Qt::WindowMaximized );
  m_recogniserBrowserCom->hideRootWidget();
  m_recogniserTestPadCom->hideRootWidget();
  m_sqlBrowserCom->hideRootWidget();
}



/*!
 * The action manager must have been created before calling this.
 * Asserts that the action manager is non-null.
 */
void GestureLabApplication::createMenuBar() // TODO: dissolve me
{
  Q_ASSERT( m_actionManager != 0 );

  // TODO: tune for Windows and Linux!

  // On Mac OS X, prevent the any icons (for actions) from appearing in the menubar
  // TODO: remove this if & when QMenu::setIconsVisible() is implemented by Trolltech
#ifdef Q_WS_MAC // _IS_ Mac
  extern void qt_mac_set_menubar_icons(bool b); // from qmenu_mac.cpp
  qt_mac_set_menubar_icons( false );
#endif


  m_globalMenuBar = new QMenuBar(); // TODO: DOC ME: intensionally parent-LESS -> need another version for windows...
  Q_ASSERT( m_globalMenuBar != 0 );


  m_fileMenu = m_globalMenuBar->addMenu(tr("&File"));
  foreach (QAction *action, m_actionManager->fileActions()->actions())
    m_fileMenu->addAction( action );
  
  m_editMenu = m_globalMenuBar->addMenu( tr("&Edit") );
  foreach ( QAction *action, m_actionManager->editActions()->actions() )
    m_editMenu->addAction( action );

  m_windowMenu = m_globalMenuBar->addMenu( tr("&Window") );
  foreach ( QAction *action, m_actionManager->windowActions()->actions() )
    m_windowMenu->addAction( action );

#if 0
  m_helpMenu = m_globalMenuBar->addMenu( tr("&Help") );
  foreach ( QAction *action, m_actionManager->helpActions()->actions() )
    m_helpMenu->addAction( action );
#else
  
#ifdef Q_WS_MAC
  // We can put it anywhere, as Qt will move / merge it into the app menu
  m_fileMenu->addAction( m_actionManager->appAboutAction() );
#else
  m_helpMenu = m_globalMenuBar->addMenu( tr("&Help") );
  m_helpMenu->addAction( m_actionManager->appAboutAction() );
#endif

#endif
}


bool GestureLabApplication::reconnectDatabase()
{
  Q_ASSERT( m_settingsModel != 0 );

  /*
   * Cleanup any existing DB
   */
  if ( m_dbController != 0 )
    m_dbController->setModel( 0 ); // no need to delete the controller
  if ( m_dbModel != 0 )
    m_dbModel->deleteLater(); // give other a change to disconnect safely first

  if ( m_db.isOpen() ) {
    m_db.close();
  }
  foreach ( const QString& name, m_db.connectionNames() )
    m_db.removeDatabase( name );

  QString password;
  ConnectionDialog* dlg = new ConnectionDialog( m_settingsController, m_dbController );
  if ( dlg->exec() == QDialog::Rejected ) {
    appQuit(); // warning - this DOES return to us, the caller -- it is event processing that stops.
    return false;
  }
  password = dlg->password();
  delete dlg;


  /*
   * Create and init DB
   */

  m_db = QSqlDatabase::addDatabase( m_settingsModel->value(DigestSettings::dbTypeKey).toString() );
#if 0
  QString dataDir = QDir::homePath() + "/Library/Digest/"; // TODO: keep me in the app's settings!
  QDir dir;
  if ( ! dir.exists(dataDir) )
    dir.mkdir( dataDir );
  m_dbConnectionName = dataDir + "/database.dat";
#endif
  

  if ( m_settingsModel->value(DigestSettings::dbIsRemoteKey).toBool() ) {
    m_db.setDatabaseName( m_settingsModel->value(DigestSettings::dbNameKey).toString() );
    m_db.setHostName( m_settingsModel->value(DigestSettings::dbHostnameKey).toString() );
    m_db.setPort( m_settingsModel->value(DigestSettings::dbPortKey).toInt() );
  } else {
    m_db.setDatabaseName( m_settingsModel->value(DigestSettings::dbFilenameKey).toString() );
  }

  if ( ! m_db.open(m_settingsModel->value(DigestSettings::dbUsernameKey).toString(),
		   password) ) {
    qDebug("ERROR OPENING DATABASE!");
    /*
      TODO: emit an error signal! - catch that in the gui code to report it!
      // TODO: improve error message
      QMessageBox::critical(0, qApp->tr("Cannot open database"),
      qApp->tr("Unable to establish a database connection.\n\n"
      "Click Cancel to exit."), QMessageBox::Cancel,
      QMessageBox::NoButton);
    */

    // TODO: try again

    return false;
  }
  DigestDbModel::createTables( m_db );


  /*
   * INIT DATABASE MVC SYSTEM
   */
  m_dbModel = new DigestDbModel( m_db, this );
  if ( m_dbController == 0 )
    m_dbController = new DigestDbController( m_dbModel, this );
  else
    m_dbController->setModel( m_dbModel );

  return true;
}


// TODO: re-write doc:
/*!
 * Note: This differs from closeDiagram() in that this method accounts for not
 *       only document windows but also for the Gesture & SQL browsers and the
 *       preference & about boxes (the latter two being non-modal on Mac OS X).
 *       This is what the action manager should call on File->Close, as to keep
 *       the app consistent with other apps on Mac OS X (i.e. Command+W closes
 *       any window other than tool windows). This may need altering for other
 *       windowing environments.
 */
void GestureLabApplication::closeActiveWindow()
{
  QWidget* w = activeWindow(); // cache it just in case it's expensive
  if ( w != 0 )
    w->close();
}


/*!
 * Shows the non-modal preferences box dialog.
 *
 * If the preferences dialog is already open (but possibly behind another window),
 * then it will be brought to the foreground.
 *
 * The dialog is set to automatically delete itself when it is closed, which
 * will null-ify our guarded pointer, allowing a new one to be created later.
 */
void GestureLabApplication::showAppPrefs()
{
  if ( ! m_prefsDlg.isNull() )
    {
      // Already exists - bring it to the front
      m_prefsDlg->activateWindow();
      m_prefsDlg->raise();
    }
  else
    {
      // Create a new dialog and show it.
      // The dialog should be fixed in size and only have a border, tile-bar and close button.
      m_prefsDlg = new GestureLabPrefsDialog( m_settingsController, 0,
					    Qt::Window
					    | Qt::WindowTitleHint
					    | Qt::WindowSystemMenuHint );
      QRect r = QApplication::desktop()->availableGeometry();
      m_prefsDlg->move( r.width()/2 - m_prefsDlg->width()/2,
			 (int)((float)(r.height()/2 - m_prefsDlg->height()/2) * 0.5) ); // get centre then halve it
      m_prefsDlg->setAttribute( Qt::WA_DeleteOnClose );
      m_prefsDlg->show();
    }
}


// TODO: implement me!
void GestureLabApplication::showAppHelp()
{
  qDebug("GestureLabApplication::showAppHelp");
}


/*!
 * Shows the non-modal about box dialog. It looks and behaves according to Apple HIG.
 *
 * If the about box is already open (but possibly behind another window),
 * then it will be brought to the foreground.
 *
 * The dialog is set to automatically delete itself when it is closed, which
 * will null-ify our guarded pointer, allowing a new one to be created later.
 */
void GestureLabApplication::showAppAbout()
{
  if ( !m_aboutBoxDlg.isNull() )
    {
      // Already exists - bring it to the front
      m_aboutBoxDlg->activateWindow();
      m_aboutBoxDlg->raise();
    }
  else
    {
      // Create a new dialog and show it.
      // The dialog should be fixed in size and only have a border, tile-bar and close button.
      m_aboutBoxDlg = new QDialog( 0, Qt::Window | Qt::WindowTitleHint | Qt::WindowSystemMenuHint );
      Ui::AboutBoxForm aboutBoxUi;
      aboutBoxUi.setupUi( m_aboutBoxDlg );
      QRect r = QApplication::desktop()->availableGeometry();
      m_aboutBoxDlg->move( r.width()/2 - m_aboutBoxDlg->width()/2,
			 (int)((float)(r.height()/2 - m_aboutBoxDlg->height()/2) * 0.5) ); // get centre then halve it
      m_aboutBoxDlg->setAttribute( Qt::WA_DeleteOnClose );
      m_aboutBoxDlg->show();
    }
}

/*!
 * Try to quit the application immediately.
 *
 * This does NOT depend on this being the last window to close.
 */
void GestureLabApplication::appQuit()
{
  QApplication::exit( 0 );
}


/*!
 * This services an inter-component message request.
 *
 * All messages are case \em{in}sensitive.
 *
 * Currently supports only "show X" and "new X" commands, where X is the name of
 * a component.
 * This command may be followed by one or more "command line arguments".
 *
 * Examples:
 * \code
 * show TrainingAssistant
 * show GestureBrowser searchtype="sqlwhere" search="ID in (11, 22)"
 * \endcode
 */
void GestureLabApplication::onRequest( const QString& message )
{
  QStringList tokens = message.split(" ", QString::SkipEmptyParts );

  if ( tokens.size() >= 2 )
    {
      QString    cmd  = tokens.takeFirst().toLower(); 
      QByteArray key  = tokens.takeFirst().toLower().toLatin1();
      QString    args = tokens.join(" "); // join the remaining tokens

      if ( cmd == "show" )
	{
	  foreach ( AbstractGuiDbComponent* component, m_components ) {
	    Q_ASSERT( component != 0 );
	    if ( component->key().toLower() == key ) {
	      component->showRootWidget(); // call even if visible, as to raise it
	      component->execMessage( args );
	      break;
	    }
	  }
	}
      else if ( cmd == "new" )
	{
	  StdGuiDbComponent* c = 0;
	  if ( key == ExperimentAssistantComponent::classKey().toLower() )
	    c = new ExperimentAssistantComponent( m_dbController, m_jvm );
	  else if ( key == TrainingAssistantComponent::classKey().toLower() )
	    c = new TrainingAssistantComponent( m_dbController, m_jvm );
	  if ( c ) {
	    c->setDeleteOnClose( true ); // required, as we don't explicitly delete it
	    c->showRootWidget();
	  }
	}
    }
}
