// -*- c++ -*-  (for Emacs)

// Gesture Lab - 7 Oct, 2005

/*  -*- c++ -*-  (for Emacs)
 *
 *  gesturelabapplication.h
 *  Nodal
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *  Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  Original file:
 *
 *    gesturelabapplication.h
 *    EverGreen
 *
 *    Created by Aidan Lane on Mon Jul 19 2004.
 *    Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GESTURELABAPPLICATION_H
#define GESTURELABAPPLICATION_H


#include <QApplication>

#include <QHash>
#include <QPointer>
#include <QSqlDatabase>

#include <jni.h>

#include "digest.h" // Digest namespace
#include "gesturelabprefsdialog.h"

class QActionGroup;
class QAction;
class QDialog;
class QMenuBar;

class ActionManager;
class DigestDbModel;
class DigestDbController;
class SettingsModel;
class SettingsController;
// Components:
class AbstractGuiDbComponent;
class ExperimentBrowserComponent;
class GestureBrowserComponent;
class RecogniserBrowserComponent;
class RecogniserTestPadComponent;
class SqlBrowseComponent;


/*!
 * Note: GestureLabApplication is to make no assumptions as to which actions are
 *       available in ActionManager, only the groups of actions.
 *       Instead, we provide slots for which the action manager may connect
 *       to if and when required.
 */
class GestureLabApplication : public QApplication {

  Q_OBJECT

public:
  GestureLabApplication( int& argc, char** argv );
  virtual ~GestureLabApplication();

  bool event( QEvent* );  


public slots:
  bool reconnectDatabase();

  void closeActiveWindow();

  void showAppPrefs();
  void showAppHelp();
  void showAppAbout();
  void appQuit();  


private slots:
  void onRequest( const QString& message );


private:
  void init();
  void initJvm();
  void setupUi();
  void createMenuBar();

  JavaVM* m_jvm;

  QSqlDatabase  m_db;
  QString       m_dbConnectionName;

  DigestDbModel*       m_dbModel;
  DigestDbController*  m_dbController;

  SettingsModel*       m_settingsModel;
  SettingsController*  m_settingsController;

  ActionManager* m_actionManager;

  // The following are used to point to modal-less, single instance dialogs
  // that will remain allocated until closed by user.
  QPointer<ExperimentBrowserComponent>  m_experimentBrowserCom;
  QPointer<GestureBrowserComponent>     m_gestureBrowserCom;
  QPointer<RecogniserBrowserComponent>  m_recogniserBrowserCom;
  QPointer<RecogniserTestPadComponent>  m_recogniserTestPadCom;
  QPointer<SqlBrowseComponent>          m_sqlBrowserCom;
  QPointer<GestureLabPrefsDialog>       m_prefsDlg;
  QPointer<QDialog>                     m_aboutBoxDlg;

  QList<AbstractGuiDbComponent*> m_components;

  QMenuBar* m_globalMenuBar; // application-wide / global menu bar

  QMenu* m_fileMenu;
  QMenu* m_editMenu;
  QMenu* m_windowMenu;
  QMenu* m_helpMenu;

  QString m_prevPath;
};


#endif // ! GESTURELABAPPLICATION_H
