/*
 *  main.cpp
 *  Nodal
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24, 2005.
 *  Copyright 2005 CEMA, Monash University. All rights reserved.
 *
 *  This file was originally created as part of "EverGreen", a plant modelling
 *  system that was developed as part of my (Aidan Lane's) Honours Thesis.
 *  Vist the project's web page via http://www.csse.monash.edu.au/~alane/
 *		Created by Aidan Lane on Tue Jul ? 2004.
 *		Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "gesturelabapplication.h"


int main( int argc, char ** argv )
{
  GestureLabApplication a( argc, argv );
    
  /*
   * GestureLab doesn't use any of Qt's plugins (e.g. SQL drivers not compiled
   * into libQtSql.4.dylib and image formats, such as jpeg and svg).
   * If it did, then we would bundle them into the application.
   * We need to prevent Qt from searching out for plugins on the system.
   * This is because in release mode, install_name_tool (a Mac OS X tool) is
   * used to redirect the program and the bundled Qt libraries to refer only
   * to their bundled Qt siblings. If Qt were allowed to then try and load a
   * plugin located in the system's Qt directory, the plugins would load
   * additional images of the Qt libraries, as they would still refer to the
   * system's, not those in the bundle. This leads to lots of problems,
   * causing run-time warnings to be printed, such as:
   *
   * QObject::moveToThread: Current thread (0x19885e0) is not the object's thread (0x193cca0).
   * Cannot move to target thread (0x193cca0)
   *
   * Therefore, we simply erase the library paths, preventing libraries with
   * non-explicit paths (e.g. plugins) from being loaded.
   */
  a.setLibraryPaths(QStringList());
 
#if defined (Q_WS_MAC)
  /*
   * On Mac OS X, there is no top-level widget that owns all other windows.
   * The GestureLabApplication is a QObject on this platform, which owns a
   * parent-less menu bar.
   * Even when the last document window is closed, we still want the app to
   * stay open, with the menu-bar availble.
   */
  a.setQuitOnLastWindowClosed( false );
#endif

  return a.exec();
}
