/*  -*- c++ -*-  (for Emacs)
 *
 *  connectiondialog.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jan 05 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CONNECTIONDIALOG_H
#define CONNECTIONDIALOG_H


#include <QDialog>

#include <QHash>

#include "MvcSettings/abstractsettingsview.h"
#include "MvcDigestDb/abstractdigestdbview.h"

#include "ui_connectiondialogform.h"


/*!
 * \brief The ConnectionDialog class provides allow the user to connect to a
 *        database.
 */
class ConnectionDialog : public QDialog,
			 public AbstractSettingsView,
			 public AbstractDigestDbView {

  Q_OBJECT

public:
  ConnectionDialog( AbstractController* settingsController = 0,
		    AbstractController* digestDbController = 0,
		    QWidget* parent = 0, Qt::WindowFlags flags = 0 );

  QString password() const;

signals:
  void dbReconnectRequested();


protected:
  void customEvent( QEvent* );
  void settingsResetEvent( VEvent* );
  void digestDbResetEvent( VEvent* );


private slots:
  void on_chooseFileButton_clicked();


private:
  Ui::ConnectionDialogForm  m_ui;
  QHash<QString, QString>   m_driverToLabel;
};


#endif // ! CONNECTIONDIALOG_H
