/*  -*- c++ -*-  (for Emacs)
 *
 *  gesturelabprefsdialog.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Aug 25 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "gesturelabprefsdialog.h"

#include <QSettings>

#include "MvcSettings/settingsmodel.h"
#include "MvcSettings/settingscontroller.h"

#include "digestsettings.h"


/*!
  \class GestureLabPrefsDialog

  \brief The GestureLabPrefsDialog class provides a graphical interface for
         changing application-wide settings.

  It was designed for non-modal use, where all changes come in to effect
  immediately.
  Hence there is a "Close" push button (not shown on the Mac OS X version,
  as to suit Apple HIG) and no "Ok" or "Cancel" push buttons.
*/


/*!
  Constructs a preferences dialog with the given \em parent and \em flags
  and attaches itself to the \em controller.

  Asserts that the \em controller is non-null.
*/
GestureLabPrefsDialog::GestureLabPrefsDialog( SettingsController* c,
					      QWidget* parent, Qt::WindowFlags flags )
   : QDialog(parent, flags)
{
  Q_ASSERT( c );

  m_ui.setupUi( this );

  c->bind( m_ui.strokeWidthSlider, "value",
	   SIGNAL(valueChanged(double)), DigestSettings::inputStrokeWidthKey );
  c->bind( m_ui.strokeWidthSpinBox, "value",
	   SIGNAL(valueChanged(double)), DigestSettings::inputStrokeWidthKey );
  c->bind( m_ui.animationSpeedSlider, "value",
	   SIGNAL(valueChanged(double)), DigestSettings::inputAnimationSpeedKey );
  c->bind( m_ui.animationSpeedSpinBox, "value",
	   SIGNAL(valueChanged(double)), DigestSettings::inputAnimationSpeedKey );
  c->bind( m_ui.multiStrokeTimeoutSlider, "value",
	   SIGNAL(valueChanged(double)), DigestSettings::inputMultiStrokeTimeoutKey );
  c->bind( m_ui.multiStrokeTimeoutSpinBox, "value",
	   SIGNAL(valueChanged(double)), DigestSettings::inputMultiStrokeTimeoutKey );
  c->bind( m_ui.mouseAsPenCheckBox, "checked",
	   SIGNAL(toggled(bool)), DigestSettings::inputMouseAsPenKey );
  c->bind( m_ui.recordHiResCheckBox, "checked",
	   SIGNAL(toggled(bool)), DigestSettings::inputRecordHiResKey );

    // Hide the Close push button on the Mac - to match Apple's pref dialogs
#ifdef Q_WS_MAC
  Q_ASSERT( m_ui.closePushButton );
  m_ui.closePushButton->hide();
  setMinimumHeight( minimumHeight() - m_ui.closePushButton->height() );
  setMaximumHeight( maximumHeight() - m_ui.closePushButton->height() );
#endif
}
