TEMPLATE = lib
LANGUAGE = C++

include( ../../config.pri ) ### Warning! we must set TEMPLATE and TARGET before we do this

CONFIG	+= qt warn_on  ### Warning! release/debug is set by config.pri
QT      += sql
QT      -= gui  # remove the GUI component (included by default), as we don`t use it

unix:QMAKE_POST_LINK = sh postlinkscript_unix.sh # works with Mac OS X, Linux, etc...

unix {
  UI_DIR = .ui
  MOC_DIR = .moc
  OBJECTS_DIR = .obj
}


# LIBRARY: Java Virtual Machine
# TODO: make this system independant!
INCLUDEPATH += /System/Library/Frameworks/JavaVM.framework/Headers
LIBS += -framework JavaVM


# LIBRARY HEADER FILES
DEPENDPATH += ../include
INCLUDEPATH += ../include


# LIBRARY: Gesture
PRE_TARGETDEPS += ../Gesture/libGesture.dylib
LIBS += ../Gesture/libGesture.dylib
include( ../include/Gesture/paths.pri )

# LIBRARY: MvcCore
PRE_TARGETDEPS += ../MvcCore/libMvcCore.dylib
LIBS += ../MvcCore/libMvcCore.dylib
include( ../include/MvcCore/paths.pri )

# LIBRARY: MvcDigestDb
PRE_TARGETDEPS += ../MvcDigestDb/libMvcDigestDb.dylib
LIBS += ../MvcDigestDb/libMvcDigestDb.dylib
include( ../include/MvcDigestDb/paths.pri )


DEPENDPATH  += . \
               .. \
               linear

INCLUDEPATH += . \
               .. \
               linear

HEADERS += ../sharedmacros.h \
           abstractfeature.h \
           abstractfeaturefactory.h \
           abstractrecogniser.h \
           abstractrecogniserfactory.h \
           featurefactory.h \
           javarecogniserwrapper.h \
           recogniserfactory.h \
           stlfeaturefactoryplugin.h \
           stlfeatureinterface.h \
           stlfeaturefactorywrapper.h \
           stlfeaturewrapper.h \
           stlrecogniserfactoryplugin.h \
           stlrecogniserinterface.h \
           stlrecogniserfactorywrapper.h \
           stlrecogniserwrapper.h \
           stlrecognitioncommon.h

SOURCES += abstractfeature.cpp \
           abstractrecogniser.cpp \
           featurefactory.cpp \
           javarecogniserwrapper.cpp \
           recogniserfactory.cpp \
           stlfeaturefactorywrapper.cpp \
           stlfeaturewrapper.cpp \
           stlrecogniserfactorywrapper.cpp \
           stlrecogniserwrapper.cpp
