/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractfeature.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Sun Apr 9 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "abstractfeature.h"


/*!
  \fn QByteArray AbstractFeature::key() const

  Returns the feature's "key". This is used for identifying features for
  purposes such as recording the types that a trained recogniser depends on and
  also for use in "factories".

  This string should only contain lower-case characters. All string matching
  performed with it will be case-insensitive.

  \b Note: This does not return a (const) reference for the sake of "wrappers"
           (e.g. JavaFeatureWrapper and StlFeatureWrapper), which may have
	   to convert the string from a different structure, usually with the use
	   of a temporary variable. Qt's implicit sharing will help performance.
*/


/*!
  \fn QString AbstractFeature::title() const

  Returns the feature's "title". This is used in the application's user
  interface to label the feature in a human friendly / readable manner.

  \b Note: This does not return a (const) reference for the sake of "wrappers"
           (e.g. JavaFeatureWrapper and StlFeatureWrapper), which may have
	   to convert the string from a different structure, usually with the use
	   of a temporary variable. Qt's implicit sharing will help performance.
*/


/*!
  \fn QString AbstractFeature::description() const

  Returns the feature's "description". This is used in the application's user
  interface to provide more information to the user about the feature.

  A subset of HTML may be used, such as to make the text bold and change its
  colour, size and alignment. Please see the Qt documentation for more details on
  its HTML support.

  \b Note: This does not return a (const) reference for the sake of "wrappers"
           (e.g. JavaFeatureWrapper and StlFeatureWrapper), which may have
	   to convert the string from a different structure, usually with the use
	   of a temporary variable. Qt's implicit sharing will help performance.
*/
