/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractrecogniserfactory.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Jan 27 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTRECOGNISERFACTORY_H
#define ABSTRACTRECOGNISERFACTORY_H


#include <QList>
#include <QString>

#include <jni.h>

class QByteArray;
class QObject;

class AbstractRecogniser;
class DigestDbModel;


/*! 
 * \brief The AbstractRecogniserFactory class creates AbstractRecogniser objects.
 *
 * Note that QByteArray is more than enough for keys.
 * There is no need for QString, and we definitely don't want the keys to be
 * language dependant.
 *
 * Also on the topic of QByteArray, from the Qt 4.0.0 documentation:
 * "Using QByteArray is much more convenient than using const char *.
 * Behind the scenes, it always ensures that the data is followed by a '\\0'
 * terminator, and uses implicit sharing (copy-on-write) to reduce memory
 * usage and avoid needless copying of data."
 */
class AbstractRecogniserFactory {

public:
  virtual ~AbstractRecogniserFactory() {}

  virtual bool open( const QString& pluginFilename ) = 0;

  virtual QList<QByteArray> keys() = 0;
  virtual AbstractRecogniser* create( const QByteArray& key,
				      JavaVM* jvm,
				      DigestDbModel* digestDbModel,
				      QObject* parent = 0 ) = 0;
  virtual QString title( const QByteArray& key ) = 0;
  virtual QString description( const QByteArray& key ) = 0;
};


#endif // ! ABSTRACTRECOGNISERFACTORY_H
