/*  -*- c++ -*-  (for Emacs)
 *
 *  featurefactory.h
 *  Digest
 * 
 *  Created by Aidan Lane on Mon Jul 11 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef FEATUREFACTORY_H
#define FEATUREFACTORY_H


#include <QList>
#include <QString>

#include <jni.h>

class QByteArray;
class QObject;

class AbstractFeature;



/*! \brief The FeatureFactory class creates AbstractFeature objects.
 *
 * Note that QByteArray is more than enough for keys.
 * There is no need for QString, and we definitely don't want the keys to be
 * language dependant.
 *
 * Also on the topic of QByteArray, from the Qt 4.0.0 documentation:
 * "Using QByteArray is much more convenient than using const char *.
 * Behind the scenes, it always ensures that the data is followed by a '\\0'
 * terminator, and uses implicit sharing (copy-on-write) to reduce memory
 * usage and avoid needless copying of data."
 */ 
class FeatureFactory {
public:
  static const QList<QByteArray>& keys();
  static AbstractFeature* create( const QByteArray& key,
				  JavaVM* jvm, QObject* parent = 0 );
  static QString title( const QByteArray& key );
  static QString description( const QByteArray& key );

  static void loadPlugins( JavaVM* jvm );
  static void unloadPlugins();
};


#endif // ! FEATUREFACTORY_H
