/*  -*- c++ -*-  (for Emacs)
 *
 *  javarecogniserwrapper.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Oct 28 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef JAVARECOGNISERWRAPPER_H
#define JAVARECOGNISERWRAPPER_H


#include "abstractrecogniser.h"


class JavaRecogniserWrapper : public AbstractRecogniser {

public:
  JavaRecogniserWrapper( const QString& javaClassName,
			 JavaVM* jvm,
			 DigestDbModel* digestDbModel,
			 QObject* parent = 0 );

  virtual ~JavaRecogniserWrapper();

  virtual QByteArray  key()         const;
  virtual QString     title()       const;
  virtual QString     description() const;

  QHash<QString, QVariant> defaultParams() const;

  const QString& javaClassName() const;


protected:
  virtual bool initTraining( const QList<QByteArray>& featureKeys,
			     const QHash<QString, QVariant>& params );
  virtual bool examineSample( const FeatureVec& featureVec,
			      const QSet<int>& classes );
  virtual bool finaliseTraining();

  virtual bool writeModelFile( const QString& fileName );
  virtual bool readModelFile( const QString& fileName );

  virtual Stroke flatten( const StrokeList& strokes );
  virtual ClassProbabilities classify( const FeatureVec& featureVec );

  jmethodID tryGetMethodID( jclass cls, const char* name, const char* sig );
  QString jstringToQString( jstring jstr ) const;


private:
  void cleanup();


  QString m_javaClassName;

  // The following is tied to the thread - do not use them outside of it
  // TODO: move what doesn't need to be global back into impl file
  // TODO: share MIDs!
  JNIEnv*    m_env;

  // Trainer class:
  jclass     m_recog_cls;
  jobject    m_recog_gref;
  jmethodID  m_recog_constructor_mid;
  jmethodID  m_recog_key_mid;
  jmethodID  m_recog_title_mid;
  jmethodID  m_recog_description_mid;
  jmethodID  m_recog_initTraining_mid;
  jmethodID  m_recog_examineSample_mid;
  jmethodID  m_recog_finaliseTraining_mid;
  jmethodID  m_recog_writeModelFile_mid;
  jmethodID  m_recog_readModelFile_mid;
  jmethodID  m_recog_flatten_mid;
  jmethodID  m_recog_classify_mid;

  // Vector class:
  jclass     m_vector_cls;
  jmethodID  m_vector_constructor_mid;
  jmethodID  m_vector_add_mid;

  // Double class:
  jclass     m_double_cls;
  jmethodID  m_double_constructor_mid;
};


#endif  // ! JAVARECOGNISERWRAPPER_H
