/*  -*- c++ -*-  (for Emacs)
 *
 *  stlfeaturefactoryplugin.h
 *  Digest
 * 
 *  Created by Aidan Lane on Sun Apr 9 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STLFEATUREFACTORYPLUGIN_H
#define STLFEATUREFACTORYPLUGIN_H


#include <set>
#include <string>


class StlFeatureFactoryPlugin;
class StlFeatureInterface;


typedef const char* (*StlFeatureFactoryPluginIdFunction)();
typedef StlFeatureFactoryPlugin* (*StlFeatureFactoryPluginInstanceFunction)();


#if (defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__))
#  define FUNC_EXPORT __declspec(dllexport)
#else
#  define FUNC_EXPORT
#endif


#define StlFeatureFactoryPlugin_id \
  "edu.ocs.csse.monash.Digest.StlFeatureFactoryPlugin/1.0"


#define EXPORT_STL_FEATURE_FACTORY_PLUGIN( PLUGIN )			\
  extern "C" FUNC_EXPORT const char* plugin_id() {			\
    return StlFeatureFactoryPlugin_id;				\
  }									\
  extern "C" FUNC_EXPORT StlFeatureFactoryPlugin* plugin_instance() { \
    static StlFeatureFactoryPlugin* _instance = 0;			\
    if ( !_instance )							\
      _instance = new PLUGIN;						\
    return _instance;							\
  }


/*!
 * Note that this class does not call "using namespace std", as that may not be
 * wanted by the feature implementer. Hence, in the places where STL
 * containers are used, they are prefixed with "std::".
 */
class StlFeatureFactoryPlugin {

public:
  virtual ~StlFeatureFactoryPlugin() {}

  virtual std::set<std::string> keys() = 0;
  virtual StlFeatureInterface* create( const std::string& key ) = 0;

  virtual std::string title( const std::string& key ) = 0;
  virtual std::string description( const std::string& key ) = 0;
};


#endif  // ! STLFEATUREFACTORYPLUGIN_H
