/*  -*- c++ -*-  (for Emacs)
 *
 *  stlfeaturewrapper.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Sun Apr 9 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "stlfeaturewrapper.h"

#include <QVariant>

#include <set>

#include "Gesture/strokelist.h"

#include "stlfeatureinterface.h"

using namespace std;


/*!
  Constructs a new C++ STL feature extractor wrapper.

  \b Note: The new object takes ownership of the \em feature and hence becomes
           responsible for the deletion of it.

  \b Note: This asserts that the \em feature is non-null. This is also asserted
           by almost all of this class's methods.
*/
StlFeatureWrapper::StlFeatureWrapper( StlFeatureInterface* feature,
				      QObject* parent )
  : AbstractFeature(parent),
    m_feature(feature)
{
  Q_ASSERT( m_feature );
}

StlFeatureWrapper::~StlFeatureWrapper()
{ delete m_feature; }


QByteArray StlFeatureWrapper::key() const {
  Q_ASSERT( m_feature );
  return QByteArray( m_feature->key().c_str() );
}

QString StlFeatureWrapper::title() const {
  Q_ASSERT( m_feature );
  return QString::fromStdString( m_feature->title() );
}

QString StlFeatureWrapper::description() const {
  Q_ASSERT( m_feature );
  return QString::fromStdString( m_feature->description() );
}

FeatureResultT
StlFeatureWrapper::calcValue( const Stroke& stroke, bool* ok ) const
{
  // TODO: One day cache the StlStroke with the stroke's shared pointer
  //       as it's ID? - As this is called MANY times for multiple features.
  Q_ASSERT( m_feature );
  const int s = stroke.size(); // invariant
  StlStroke stl_stroke( s );
  for ( int i=0; i < s; ++i ) {
    const StrokePoint& pt = stroke.at(i);
    stl_stroke[i] = StlStrokePoint(pt.x(), pt.y(),
				   pt.pressure, pt.milliTime);
  }
  return m_feature->calcValue( stl_stroke, ok );
}

StlFeatureInterface* StlFeatureWrapper::feature() const
{ return m_feature; }
