/*  -*- c++ -*-  (for Emacs)
 *
 *  stlrecogniserfactorywrapper.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Jan 27 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STLRECOGNISERFACTORYWRAPPER_H
#define STLRECOGNISERFACTORYWRAPPER_H


#include "abstractrecogniserfactory.h"


class StlRecogniserFactoryWrapper : public AbstractRecogniserFactory {

public:
  bool open( const QString& pluginFilename );

  QList<QByteArray> keys();
  AbstractRecogniser* create( const QByteArray& key,
			      JavaVM* jvm,
			      DigestDbModel* digestDbModel,
			      QObject* parent = 0 );
  QString title( const QByteArray& key );
  QString description( const QByteArray& key );
};


#endif // ! STLRECOGNISERFACTORYWRAPPER_H
