/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractcontroller.h
 *  Digest
 * !
 *  Created by Aidan Lane on Thu Jun 9 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTCONTROLLER_H
#define ABSTRACTCONTROLLER_H


#include "mvcbase.h"

#include <QSet>
#include <QPointer>

#include "controllerevents.h"


class AbstractModel;
class AbstractView;

typedef QSet<AbstractView*>          AbstractViewSet;
typedef QSetIterator<AbstractView*>  AbstractViewSetIterator;


/*!
 * \brief The AbstractController class provides an abstract base for all
 *        controllers in the Model-View-Controller system.
 */
class AbstractController : public MvcBase {

public:
  AbstractController( QObject* objectPtr );
  virtual ~AbstractController();

  AbstractModel* model() const;
  void setModel( AbstractModel* model );

  const AbstractViewSet& views() const { return m_views; }
  void attachView( AbstractView* view );
  void detachView( AbstractView* view );


protected:
  virtual void dispatchEvent( CEvent* );

  virtual void changeModelEvent( CChangeModelEvent* );
  virtual void viewAttachEvent( CViewAttachEvent* );
  virtual void viewDetachEvent( CViewDetachEvent* );
  virtual void detachAllViewsEvent( CEvent* );
  


private:
  AbstractModel*    m_model; // note: can't use QPointer
  QPointer<QObject> m_modelObject;
  AbstractViewSet   m_views;
};


#endif  // ! ABSTRACTCONTROLLER_H
