/*  -*- c++ -*-  (for Emacs)
 *
 *  attributedoccontroller.cpp
 * 
 *  Created by Aidan Lane on Mon Dec 19 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "attributedoccontroller.h"

#include <QCoreApplication>

#include "attributedoc.h"
//TODO: re-enable me:
#if 1
#include "abstractdocview.h"
#else
#include "abstractattributedocview.h"
#endif

/*!
 * Constructs an element document controller with the given \em parent.
 */
AttributeDocController::AttributeDocController( QObject* parent )
  : DocController(parent)
{}


/*!
 * Constructs an element document controller with the given \em parent and uses
 * \em doc as its model.
 */
AttributeDocController::AttributeDocController( AbstractModel* doc, QObject* parent )
  : DocController(doc, parent)
{}


/*!
 * Convenience method.
 *
 * Returns a cached guarded pointer that has been dynamically cast to
 * AttributeDoc* from AbstractModel*.
 *
 * See also AbstractController::model().
 */
AttributeDoc* AttributeDocController::attributeDoc() const {
  return c_attributeDoc;
}


/*!
 * The element doc controller event dispatcher.
 *
 * \b Warning! It is assumed that the events have their correct type set
 *             (as it uses static casts).
 *
 * Asserts that the \em event is non-null.
 */
void AttributeDocController::dispatchEvent( CEvent* event )
{
  Q_ASSERT( event != 0 );

  DocController::dispatchEvent( event );

  if ( event->moduleId() != MvcCore::id() ) return; // prevent event type conflicts

  switch ( event->type() )
    {
    case CAttributeDocEvent::AttributesSetValues:
      attributesSetValuesEvent( static_cast<CAttributesSetValuesEvent*>(event) );
      break;
    case CAttributeDocEvent::AttributesRemove:
      attributesRemoveEvent( static_cast<CAttributesRemoveEvent*>(event) );
      break;
    default:
      break;
    }
}



/* Post a DocViewEvent to our views.
 * Any DocView object that has the same address as the value of "exclude"
 * will be exluded from the updates.
 * Therefore, set "exclude" to 0 if you don't want to exclude anything.
 * It asserts that the view pointer is non-null.
 * BTW: I know, this is very hacky :-)
 */
#define POST_VIEW_EVENT(EVENT,EXCLUDE)	{AbstractViewSetIterator i(views()); while(i.hasNext()) { AbstractView* v=i.next(); Q_ASSERT(v!=0); Q_ASSERT(v->objectPtr()!=0); if (v->objectPtr() != (EXCLUDE)) QCoreApplication::postEvent( v->objectPtr(), new EVENT ); }}

#define POST_MODIFIED_STATE_CHANGE_EVENTS(STATE) { if ( STATE != c_attributeDoc->isModified()) {QCoreApplication::postEvent( c_attributeDoc, new MChangeModifiedStateEvent(STATE) ); POST_VIEW_EVENT( VModifiedStateChangedEvent(STATE, this), 0 ); } }



/*!
 * Re-implemented, as to also have the pointer returned by attributeDoc() updated.
 *
 * Asserts that the \em event is non-null.
 */
void AttributeDocController::changeModelEvent( CChangeModelEvent* event )
{
  Q_ASSERT( event != 0 );
  DocController::changeModelEvent( event );
  c_attributeDoc
    = ( (event->model()==0)
	? 0
	: qobject_cast<AttributeDoc*>(event->model()->objectPtr()) );
}



/*!
 * Asserts that the \em event and the attributeDoc() are both non-null
 */
void AttributeDocController::attributesSetValuesEvent( CAttributesSetValuesEvent* event )
{
  Q_ASSERT( event != 0 );
  Q_ASSERT( c_attributeDoc != 0 );

  QCoreApplication::postEvent( c_attributeDoc,
			       new MAttributesSetValuesEvent(event->attributes()) );

#if 0 // TODO: re-enable me:
  POST_VIEW_EVENT( VAttributesAddedEvent( event->attributes(), this),
		   event->updateSender() ? 0 : event->sender() );
#endif
  POST_MODIFIED_STATE_CHANGE_EVENTS( true ); // -> Document has been modified
}


/*!
 * Asserts that the \em event and the attributeDoc() are both non-null
 */
void AttributeDocController::attributesRemoveEvent( CAttributesRemoveEvent* event )
{
  Q_ASSERT( event != 0 );
  Q_ASSERT( c_attributeDoc != 0 );

  QCoreApplication::postEvent( c_attributeDoc,
			       new MAttributesRemoveEvent(event->attributeTypes()) );

#if 0 // TODO: re-enable me:
  POST_VIEW_EVENT( VAttributesRemovedEvent(event->attributeTypes(), this),
		   event->updateSender() ? 0 : event->sender() );
#endif
  POST_MODIFIED_STATE_CHANGE_EVENTS( true ); // -> Document has been modified
}
