/*  -*- c++ -*-  (for Emacs)
 *
 *  attributedoccontroller.h
 * 
 *  Created by Aidan Lane on Mon Dec 19 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ATTRIBUTEDOCCONTROLLER_H
#define ATTRIBUTEDOCCONTROLLER_H


#include "doccontroller.h"

#include <QPointer>

#include "attributedoccontrollerevents.h"

class AttributeDoc;


/*!
 * \brief The AttributeDocController class is responsible for controlling the
 *        communication between an AttributeDoc and its views.
 *
 * Note that the AttributeDoc's pointer is stored internally as a "guarded pointer".
 * Hence, if the AttributeDoc is deleted, our reference to it will be automatically
 * set back to NULL.
 */
class AttributeDocController : public DocController {

  Q_OBJECT

public:
  AttributeDocController( QObject* parent = 0 );
  AttributeDocController( AbstractModel* doc, QObject* parent = 0 );

  AttributeDoc* attributeDoc() const;


protected:
  virtual void dispatchEvent( CEvent* );
  virtual void changeModelEvent( CChangeModelEvent* );
  virtual void attributesSetValuesEvent( CAttributesSetValuesEvent* );
  virtual void attributesRemoveEvent( CAttributesRemoveEvent* );


private:
  // Temporary caches:
  QPointer<AttributeDoc> c_attributeDoc;
};


#endif // ! ATTRIBUTEDOCCONTROLLER_H
