/*  -*- c++ -*-  (for Emacs)
 *
 *  attributedoccontrollerevents.h
 * 
 *  Created by Aidan Lane on Mon Dec 19 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
 
#ifndef ATTRIBUTEDOCCONTROLLEREVENTS_H
#define ATTRIBUTEDOCCONTROLLEREVENTS_H


#include "doccontrollerevents.h"


class CAttributeDocEvent : public CDocEvent {
public:
  enum Type {
    AttributesSetValues  = CDocEvent::User,
    AttributesRemove,
    User                 = CDocEvent::User + 1000
  };

public:
  CAttributeDocEvent( Type type,
		      QObject* sender = 0, Flags flags = NoFlags )
    : CDocEvent((CDocEvent::Type)type, sender, flags) {}
};


/*!
 * Set Values == Add or Change/Modify (i.e. auto added if does not already exist).
 *
 * \b Note: This is not called "MAttributesSetEvent", because of the "set"
 *          container, which could cause confusion.
 */
class CAttributesSetValuesEvent : public CAttributeDocEvent,
				  public AttributesContainer {
public:
  CAttributesSetValuesEvent( const QHash<int, QVariant>& attributes,
			     QObject* sender = 0, Flags flags = NoFlags )
    : CAttributeDocEvent(AttributesSetValues, sender, flags),
      AttributesContainer(attributes) {}

  CAttributesSetValuesEvent( int attributeType, const QVariant& attributeValue,
			     QObject* sender = 0, Flags flags = NoFlags )
    : CAttributeDocEvent(AttributesSetValues, sender, flags),
      AttributesContainer(attributeType, attributeValue) {}
};


class CAttributesRemoveEvent : public CAttributeDocEvent,
			       public AttributeTypesContainer {
public:
  CAttributesRemoveEvent( const QSet<int> attributeTypes,
			  QObject* sender = 0, Flags flags = NoFlags )
    : CAttributeDocEvent(AttributesRemove, sender, flags),
      AttributeTypesContainer(attributeTypes) {}

  CAttributesRemoveEvent( int attributeType,
			  QObject* sender = 0, Flags flags = NoFlags )
    : CAttributeDocEvent(AttributesRemove, sender, flags),
      AttributeTypesContainer(attributeType) {}
};


#endif // ! ATTRIBUTEDOCCONTROLLEREVENTS_H
