/*  -*- c++ -*-  (for Emacs)
 *
 *  controllerevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Sun Aug 28 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CONTROLLEREVENTS_H
#define CONTROLLEREVENTS_H


#include "mvcevent.h"
#include "mvccontainers.h"


class QObject;

class AbstractModel;
class AbstractView;


// TODO: move this stack to a separate class
// TODO: allow this to be used with abstract controller ?
// TODO: write doc about posting the undoEvent -> postEvent deletes it!
class CEvent;
class UndoRedoItem {
public:
  UndoRedoItem( CEvent* event = 0 )
    : m_event(event) {}
  CEvent* event() const { return m_event; }
private:
  CEvent* m_event;
};


/*!
 * Base class for Controller events in the Model-View-Controller event
 * system.
 *
 * Using and extending CEvent offers thread-safe event queuing (using postEvent)
 * and minial coupling.
 */
class CEvent : public MvcEvent {

public:

  enum Flag {
    NoFlags           = 0x0,
    DontUpdateSender  = 0x1,
    IsUndoEvent       = 0x2,
    IsRedoEvent       = 0x4,
  };
  Q_DECLARE_FLAGS( Flags, Flag ); // typesafe flags

  enum Type {
    ChangeModel     = MvcEvent::User,
    ViewAttach,
    ViewDetach,
    DetachAllViews,
    User            = MvcEvent::User + 1000
  };

  CEvent( Type type, QObject* sender = 0, Flags flags = NoFlags )
    : MvcEvent((MvcEvent::Type)type),
      m_sender(sender),
      m_flags(flags) {}

  /*! Returns the desination type for this event, which is MvcEvent::Controller. */
  inline static DestType classDestType() { return Controller; }
  /*! Returns classDestType(). */
  virtual DestType destType() const { return classDestType(); }
	
  QObject* sender() const { return m_sender; }
  Flags flags() const { return m_flags; }

  bool updateSender() const { return !(m_flags & DontUpdateSender); }
  bool isUndoEvent() const { return m_flags & IsUndoEvent; }
  bool isRedoEvent() const { return m_flags & IsRedoEvent; }


private:
  /* Note: The sender can't be const, as the doc may need to send message back
   *       (e.g. to revert changes).
   */
  QObject* m_sender;
  Flags    m_flags;
};
Q_DECLARE_OPERATORS_FOR_FLAGS( CEvent::Flags );


class CChangeModelEvent : public CEvent, public AbstractModelContainer {
public:
  CChangeModelEvent( AbstractModel* model,
		     QObject* sender = 0, Flags flags = NoFlags )
    : CEvent(ChangeModel, sender, flags),
      AbstractModelContainer(model) {}
};

class CViewAttachEvent : public CEvent, public AbstractViewContainer {
public:
  CViewAttachEvent( AbstractView* view,
		    QObject* sender = 0, Flags flags = NoFlags )
    : CEvent(ViewAttach, sender, flags),
      AbstractViewContainer(view) {}
};

class CViewDetachEvent : public CEvent, public AbstractViewContainer {
public:
  CViewDetachEvent( AbstractView* view,
		    QObject* sender = 0, Flags flags = NoFlags )
    : CEvent(ViewDetach, sender, flags),
      AbstractViewContainer(view) {}
};


#endif // ! CONTROLLEREVENTS_H
