/*  -*- c++ -*-  (for Emacs)
 *
 *  controllerthreadhost.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Sep 29 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CONTROLLERTHREADHOST_H
#define CONTROLLERTHREADHOST_H


#include <QThread>

#include <QCoreApplication>

#include "abstractcontroller.h"
#include "abstractmodel.h"


template <class T>
class ControllerThreadHost : public QThread {

public:
  ControllerThreadHost( QObject* parent = 0 )
    : QThread(parent),
      m_initialModel(0) {}

  ControllerThreadHost( AbstractModel* model, QObject* parent = 0 )
    : QThread(parent),
      m_initialModel(model) {}

  virtual ~ControllerThreadHost() {
    quit();
    wait(); // TODO: make wait time-out a param
    // WARNING: we delete the controller at the end of run()
  }

  T* controller() const { return m_controller; }


protected:
  virtual void run()
  {
    /* Warning:
     * The controller is created in this new thread, hence it must NOT take the
     * host object (ControllerThreadHost) as its parent.
     */
    m_controller = new T;
    if ( m_initialModel != 0 )
      QCoreApplication::postEvent( m_controller,
				   new CChangeModelEvent(m_initialModel,this) );
    exec(); // begin event-loop
    delete m_controller;
    m_controller = 0;
  }


private:
  T* m_controller;
  AbstractModel* m_initialModel;
};


#endif  // ! CONTROLLERTHREADHOST_H
