/*  -*- c++ -*-  (for Emacs)
 *
 *  doccontrollerevents.h
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    projectcontrollerevents.h
 *    Nodal
 *
 *    Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *    Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *    Original file:
 *
 *      projectevent.h
 *      EverGreen
 *
 *      Created by Aidan Lane on Sun Aug 01 2004.
 *      Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DOCCONTROLLEREVENTS_H
#define DOCCONTROLLEREVENTS_H


#include "controllerevents.h"
#include "genericcontainers.h"


/*
 * Base class to support doc controller events.
 * The events are sent from derivatives of AbstractDocView.
 *
 * When a doc processes an event form a given doc view, all registered doc views
 * (optionally with the exception of the sender) will be updated.
 * These events can be logged in lists, which is required for undo/redo
 * functionality.
 */
class CDocEvent : public CEvent {
public:
  enum Type {
    Rename        = CEvent::User,
    FileSaveTo,
    FileInitFrom,
    User          = CEvent::User + 1000
  };

  CDocEvent( Type type, QObject* sender = 0, Flags flags = NoFlags )
    : CEvent((CEvent::Type)type, sender, flags) {}
};


class CRenameEvent : public CDocEvent, public NameContainer {
public:
  CRenameEvent( const QString& name,
		QObject* sender = 0, Flags flags = NoFlags )
    : CDocEvent(Rename, sender, flags),
      NameContainer(name) {}
};


class CFileEvent : public CDocEvent, public FilenameContainer {
public:
  CFileEvent( Type type, const QString& filename,
	      QObject* sender = 0, Flags flags = NoFlags )
    : CDocEvent(type, sender, flags),
      FilenameContainer(filename) {}
};


#endif // ! DOCCONTROLLEREVENTS_H
