/*  -*- c++ -*-  (for Emacs)
 *
 *  elementdoccontroller.h
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    projectcontroller.h
 *    Nodal
 *
 *    Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *    Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *    Original file:
 *
 *      project.h
 *      EverGreen
 *
 *      Created by Aidan Lane on Wed Jul 14 2004.
 *      Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ELEMENTDOCCONTROLLER_H
#define ELEMENTDOCCONTROLLER_H


#include "attributedoccontroller.h"

#include <QPointer>

#include "elementdoccontrollerevents.h"

class ElementDoc;


/*!
 * \brief The ElementDocController class is responsible for controlling the
 *        communication between an ElementDoc and its views.
 *
 * Note that the elementDoc's pointer is stored internally as a "guarded pointer".
 * Hence, if the elementDoc is deleted, our reference to it will be automatically
 * set back to NULL.
 *
 * Warning! We always assert that the elementDoc is non-null. Hence, you can't
 * have an instance of a ElementDocController without a ElementDoc.
 * This is fine for Nodal and means that we don't need to constantly check if
 * the elementDoc is null in the release / deployment version (when assertions
 * are stripped).
 */
class ElementDocController : public AttributeDocController {

  Q_OBJECT

public:
  ElementDocController( QObject* parent = 0 );
  ElementDocController( AbstractModel* doc, QObject* parent = 0 );

  ElementDoc* elementDoc() const;


  // TODO: remove me:
public slots:
  void postElementAttributeChangeData( AbstractElement* element,
				       int attributeType,
				       const QVariant& data,
				       QObject* sender = 0,
				       CEvent::Flags flags = CEvent::NoFlags );


protected:
  virtual void dispatchEvent( CEvent* );

  virtual void changeModelEvent( CChangeModelEvent* );

  virtual void elementAddEvent( CElementAddEvent* );
  virtual void elementRemoveEvent( CElementRemoveEvent* );
  virtual void elementAttributeAddEvent( CElementAttributeAddEvent* );
  virtual void elementAttributeRemoveEvent( CElementAttributeRemoveEvent* );
  virtual void elementAttributeChangeDataEvent( CElementAttributeChangeDataEvent* );
  virtual void elementSetChangeOrderEvent( CElementSetChangeOrderEvent* );


private:
  // Temporary caches:
  QPointer<ElementDoc> c_elementDoc;
};


#endif // ! ELEMENTDOCCONTROLLER_H
