/*  -*- c++ -*-  (for Emacs)
 *
 *  elementdoccontrollerevents.h
 *
 *  Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *  Modifications Copyright (c) 2005-2006 CEMA, Monash University.
 *  All rights reserved.
 *
 *  Original file:
 *
 *    projectevent.h
 *    EverGreen
 *
 *    Created by Aidan Lane on Sun Aug 01 2004.
 *    Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
 
#ifndef ELEMENTDOCCONTROLLEREVENTS_H
#define ELEMENTDOCCONTROLLEREVENTS_H


#include "attributedoccontrollerevents.h"
#include "elementdoccontainers.h"

class AbstractElementDocView;


class CElementDocEvent : public CAttributeDocEvent {
public:
  enum Type {
    ElementAdd                  = CAttributeDocEvent::User,
    ElementRemove,
    ElementAttributeAdd,
    ElementAttributeRemove,
    ElementAttributeChangeData,
    ElementSetChangeOrder,
    User                        = CAttributeDocEvent::User + 1000
  };

  CElementDocEvent( Type type,
		    QObject* sender = 0, Flags flags = NoFlags )
    : CAttributeDocEvent((CAttributeDocEvent::Type)type, sender, flags) {}
};


class CElementEvent : public CElementDocEvent,
		      public AbstractElementContainer {
public:
  CElementEvent( Type type,
		 AbstractElement* element,
		 QObject* sender = 0,
		 Flags flags = NoFlags )
    : CElementDocEvent(type, sender, flags),
      AbstractElementContainer(element) {}
};


class CElementSetEvent : public CElementDocEvent,
			 public AbstractElementSetContainer {
public:
  CElementSetEvent( Type type,
		    const AbstractElementSet& elements,
		    QObject* sender = 0,
		    Flags flags = NoFlags )
    : CElementDocEvent(type, sender, flags),
      AbstractElementSetContainer(elements) {}
};


/*! \brief Convenience class. */
class CElementAddEvent : public CElementEvent {
public:
  CElementAddEvent( AbstractElement* element,
		    QObject* sender = 0,
		    Flags flags = NoFlags )
    : CElementEvent(ElementAdd, element, sender, flags) {}
};

/*! \brief Convenience class. */
class CElementRemoveEvent : public CElementEvent {
public:
  CElementRemoveEvent( AbstractElement* element,
		       QObject* sender = 0,
		       Flags flags = NoFlags )
    : CElementEvent(ElementRemove, element, sender, flags) {}
};


class CElementAttributeEvent : public CElementEvent,
			       public AbstractElementAttributeContainer {
public:
  CElementAttributeEvent( Type type,
			  AbstractElement* element,
			  AbstractElementAttribute* attribute,
			  QObject* sender = 0,
			  Flags flags = NoFlags )
    : CElementEvent(type, element, sender, flags),
      AbstractElementAttributeContainer(attribute) {}
};

/*! \brief Convenience class. */
class CElementAttributeAddEvent : public CElementAttributeEvent {
public:
  CElementAttributeAddEvent( AbstractElement* element,
			     AbstractElementAttribute* attribute,
			     QObject* sender = 0,
			     Flags flags = NoFlags )
    : CElementAttributeEvent(ElementAttributeAdd, element,
			     attribute, sender, flags) {}
};

/*! \brief Convenience class. */
class CElementAttributeRemoveEvent : public CElementAttributeEvent {
public:
  CElementAttributeRemoveEvent( AbstractElement* element,
				AbstractElementAttribute* attribute,
				QObject* sender = 0,
				Flags flags = NoFlags )
    : CElementAttributeEvent(ElementAttributeRemove, element,
			     attribute, sender, flags) {}
};

class CElementAttributeChangeDataEvent : public CElementAttributeEvent,
					 public DataContainer {
public:
  CElementAttributeChangeDataEvent( AbstractElement* element,
				    AbstractElementAttribute* attribute,
				    const QVariant& data,
				    QObject* sender = 0,
				    Flags flags = NoFlags )
    : CElementAttributeEvent(ElementAttributeChangeData, element,
			     attribute, sender, flags),
      DataContainer(data) {}
};


class CElementSetChangeOrderEvent : public CElementSetEvent,
				    public ElementOrderActionContainer {
public:
  CElementSetChangeOrderEvent( const AbstractElementSet& elements,
			       Action action,
			       QObject* sender = 0,
			       Flags flags = NoFlags )
    : CElementSetEvent(ElementSetChangeOrder, elements, sender, flags),
      ElementOrderActionContainer(action) {}
};


#endif // ! ELEMENTDOCCONTROLLEREVENTS_H
