/*  -*- c++ -*-  (for Emacs)
 *
 *  domaccessiblestate.cpp
 *
 *  Created by Aidan Lane on Tue May 24 2005.
 *  Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "domaccessiblestate.h"


/*!
 * Creates an XML QDomElement that represents the DomAccessibleState.
 *
 * Use initFromDOMElement() to restore the DomAccessibleState state from the
 * resulting QDomElement.
 */
QDomElement DomAccessibleState::domElement( QDomDocument& doc ) const
{
  return doc.createElement( key() );
}


/*!
 * Restore the DomAccessibleState state from a QDomElement created by
 * domElement().
 *
 * The "mode" parameter is essential when dealing with models that have objects
 * that refer to other objects, such as in graphs. In this case, this method
 * should first be called with mode=InitStructure, where the
 * objects are created and then again with mode=InitStates, where the
 * inter-object references are then set.
 *
 * Note: Returns immediately if e.tagName() != typeName().
 */
void DomAccessibleState::initFromDomElement( const QDomElement& e,
					     InitModeFlags )
{
  if ( e.tagName() != key() ) return;
}
