/*  -*- c++ -*-  (for Emacs)
 *
 *  domaccessiblestate.h
 *
 *  Created by Aidan Lane on Tue May 24 2005.
 *  Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DOMACCESSIBLESTATE
#define DOMACCESSIBLESTATE


#include <QDomDocument>
#include <QDomElement>

#include "sharedmacros.h"


class QByteArray;


/*!
 * \brief The DomAccessibleState class provides an interface for extracting
 *        and initialising an object's state as and to an XML DOM element.
 */
class DomAccessibleState {
  
public:
  enum InitMode {
    InitStructure   = 0x1, /*! Use this for building the object structure. */
    InitStates      = 0x2, /*! Use this for states and inter-object refs.  */
    AttemptInitAll  = (InitStructure | InitStates),
  };
  Q_DECLARE_FLAGS( InitModeFlags, InitMode ); // typesafe flags

  virtual ~DomAccessibleState() {}

  /*!
   * Having this method as pure-virtual forces sub-classes to implement it,
   * which is a requirement for both it and ther other methods to work correctly.
   *
   * Sub-classes must return \em their version of classKey().
   */
  virtual const QByteArray& key() const = 0;

  virtual QDomElement domElement( QDomDocument& doc ) const;
  virtual void initFromDomElement( const QDomElement& element,
				   InitModeFlags modeFlags );
};

Q_DECLARE_OPERATORS_FOR_FLAGS( DomAccessibleState::InitModeFlags );


#endif // ! DOMACCESSIBLESTATE
