/*  -*- c++ -*-  (for Emacs)
 *
 *  genericcontainers.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 10 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GENERALCONTAINERS_H
#define GENERALCONTAINERS_H


#include <QSet>
#include <QString>
#include <QVariant>

typedef QSet<int>  IdSet;


class NameContainer {
public:
  NameContainer( const QString& name ) : m_name(name) {}
  const QString& name() const { return m_name; }
private:
  const QString m_name;
};


class FilenameContainer {
public:
  FilenameContainer( const QString& filename ) : m_filename(filename) {}
  const QString& filename() const { return m_filename; }
private:
  const QString m_filename;
};


class KeyContainer {
public:
  KeyContainer( const QString& key ) : m_key(key) {}
  const QString& key() const { return m_key; }
private:
  const QString m_key;
};


class ValueContainer {
public:
  ValueContainer( const QVariant& value ) : m_value(value) {}
  const QVariant& value() const { return m_value; }
private:
  const QVariant m_value;
};

class DataContainer {
public:
  DataContainer( const QVariant& data ) : m_data(data) {}
  const QVariant& data() const { return m_data; }
private:
  const QVariant m_data;
};


/*!
 * \b Note: \em int has been used, not \em quint32, as it's what Qt has been
 *          standardised on for its indices.
 */
class IndexContainer {
public:
  IndexContainer( int index ) : m_index(index) {}
  int index() const { return m_index; }
private:
  int m_index;
};


/*!
 * \b Note: \em int has been used, not \em quint32, as it's what Qt has been
 *          standardised on for its indices.
 */
class IdContainer {
public:
  IdContainer( int id ) : m_id(id) {}
  int id() const { return m_id; }
private:
  int m_id;
};


/*!
 * \b Note: \em int has been used, not \em quint32, as it's what Qt has been
 *          standardised on for its indices.
 */
class IdSetContainer {
public:
  IdSetContainer( const IdSet& idSet ) : m_idSet(idSet) {}
  IdSetContainer( int id ) { m_idSet += id; }
  const IdSet& idSet() const { return m_idSet; }
private:
  IdSet m_idSet;
};


template <class T> 
class AddSetContainer {
public:
  AddSetContainer( const QSet<T>& addSet ) : m_addSet(addSet) {}
  AddSetContainer( T item ) { m_addSet += item; }
  const QSet<T>& addSet() const { return m_addSet; }
private:
  QSet<T> m_addSet;
};


template <class T> 
class RemoveSetContainer {
public:
  RemoveSetContainer( const QSet<T>& removeSet ) : m_removeSet(removeSet) {}
  RemoveSetContainer( T item ) { m_removeSet += item; }
  const QSet<T>& removeSet() const { return m_removeSet; }
private:
  QSet<T> m_removeSet;
};


#endif //  ! GENERALCONTAINERS_H
