/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractmodel.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 9 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTMODEL_H
#define ABSTRACTMODEL_H


#include "mvcbase.h"

#include <QPointer>

#include "modelevents.h"

class AbstractController;
class CEvent;


/*!
 * \brief The AbstractModel class provides an abstract base for all models in the
 *        Model-View-Controller system.
 */
class AbstractModel : public MvcBase {

public:
  AbstractModel( QObject* objectPtr );
  virtual ~AbstractModel();

  AbstractController* controller() const;


protected:
  virtual void dispatchEvent( MEvent* );

  virtual void changeControllerEvent( MChangeControllerEvent* );

  void postControllerEvent( CEvent* event );


private:
  AbstractController* m_controller; // note: can't use QPointer
  QPointer<QObject>   m_controllerObject;
};


#endif //  ! ABSTRACTMODEL_H
