/*  -*- c++ -*-  (for Emacs)
 *
 *  attributedoc.h
 * 
 *  Created by Aidan Lane on Mon Dec 19 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ATTRIBUTEDOC_H
#define ATTRIBUTEDOC_H


#include "doc.h"

#include <QHash>
#include <QReadWriteLock>
#include <QVariant>

#include "attributedocevents.h"

class AttributeDocController;


class AttributeDoc : public Doc {

  Q_OBJECT

public:
  AttributeDoc( QObject* parent );
  AttributeDoc( const QString& name, QObject* parent );

  AttributeDocController* attributeDocController() const;

  QHash<int, QVariant> attributes() const;
  QVariant attributeValue( int type ) const;
  bool containsAttribute( int type ) const;


protected:
  virtual void dispatchEvent( MEvent* );
  virtual void changeControllerEvent( MChangeControllerEvent* );
  virtual void attributesSetValuesEvent( MAttributesSetValuesEvent* );
  virtual void attributesRemoveEvent( MAttributesRemoveEvent* );


private:
  QHash<int, QVariant>    m_attributes;
  mutable QReadWriteLock  m_attributesLock;

  // Caches:
  AttributeDocController* c_attributeDocController;
};


#endif  // ! ATTRIBUTEDOC_H
