/*  -*- c++ -*-  (for Emacs)
 *
 *  attributedocevents.h
 * 
 *  Created by Aidan Lane on Mon Dec 19 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
 
#ifndef ATTRIBUTEDOCEVENTS_H
#define ATTRIBUTEDOCEVENTS_H


#include "docevents.h"


class MAttributeDocEvent : public MDocEvent {
public:
  enum Type {
    AttributesSetValues  = MDocEvent::User,
    AttributesRemove,
    User                 = MDocEvent::User + 1000
  };

public:
  MAttributeDocEvent( Type type )
    : MDocEvent((MDocEvent::Type)type) {}
};


/*!
 * Set Values == Add or Change/Modify (i.e. auto added if does not already exist).
 *
 * \b Note: This is not called "MAttributesSetEvent", because of the "set"
 *          container, which could cause confusion.
 */
class MAttributesSetValuesEvent : public MAttributeDocEvent,
				  public AttributesContainer {
public:
  MAttributesSetValuesEvent( const QHash<int, QVariant>& attributes )
    : MAttributeDocEvent(AttributesSetValues),
      AttributesContainer(attributes) {}

  MAttributesSetValuesEvent( int attributeType, const QVariant& attributeValue )
    : MAttributeDocEvent(AttributesSetValues),
      AttributesContainer(attributeType, attributeValue) {}
};


class MAttributesRemoveEvent : public MAttributeDocEvent,
			       public AttributeTypesContainer {
public:
  MAttributesRemoveEvent( const QSet<int> attributeTypes )
    : MAttributeDocEvent(AttributesRemove),
      AttributeTypesContainer(attributeTypes) {}

  MAttributesRemoveEvent( int attributeType )
    : MAttributeDocEvent(AttributesRemove),
      AttributeTypesContainer(attributeType) {}
};


#endif // ! ATTRIBUTEDOCEVENTS_H
