/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractelementattribute.cpp
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    project.cpp
 *    Nodal
 *
 *    Created by Aidan Lane on Wed Apr 6 2005.
 *    Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTELEMENTATTRIBUTE_H
#define ABSTRACTELEMENTATTRIBUTE_H


#include <QObject>

#include <QReadWriteLock>
#include <QString>
#include <QVariant>

#include "abstractelement.h"
#include "domaccessiblestate.h"

class QByteArray;


/*!
 * This is the base class for all element attributes, include those for arcs
 * and nodes.
 *
 * As this subclasses QObject, it can be used in a QPointer and be asked to
 * QObject::deleteLater(). It also has access to the QObject::tr() method.
 *
 * Having a AbstractElement object as the parent means that all of the AbstractElementAttributes
 * objects owned by a given AbstractElement object will be destroyed automatically with
 * the AbstractElement object.
 */
class AbstractElementAttribute : public QObject, public DomAccessibleState {

  Q_OBJECT

public:
  AbstractElementAttribute( AbstractElement* parent );

  // The following are pure-virtual, as to force sub-classes to implement them
  virtual int type() const = 0; // returns int, not Type, as to aid extensibility
  //virtual const QByteArray& key() const = 0; - declared in DomAccessibleState
  virtual const QString& title() const = 0;

  /*! \b Note: This is not pure-virtual, as some systems won't need it - e.g. Digest . */
  virtual int category() const { return 0; }
 
  QString  toString() const;
  bool     setData( const QString& data );
  QVariant toVariant() const;
  bool     setData( const QVariant& data );

  virtual QDomElement domElement( QDomDocument& doc ) const;
  virtual void initFromDomElement( const QDomElement& e,
				   InitModeFlags modeFlags );


protected:
  /*! Called and made thread-safe by toString(). */
  virtual QString  worker_toString() const = 0;
  /*! Called and made thread-safe by setData(const QString&). */
  virtual bool     worker_setData( const QString& data ) = 0;
  /*! Called and made thread-safe by toVariant(). */
  virtual QVariant worker_toVariant() const = 0;
  /*! Called and made thread-safe by setData(const QVariant&). */
  virtual bool     worker_setData( const QVariant& data ) = 0;

  mutable QReadWriteLock m_lock;
};


#endif // ! ABSTRACTELEMENTATTRIBUTE_H
