/*
 *  abstractelementbytearray.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Nov 15 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "abstractelementbytearray.h"


AbstractElementByteArray
::AbstractElementByteArray( AbstractElement* parent,
				 const QByteArray& value )
  : AbstractElementAttribute(parent),
    m_value(value)
{}


QString AbstractElementByteArray::worker_toString() const {
  return m_value;
}

bool AbstractElementByteArray::worker_setData( const QString& data ) {
  m_value = data.toAscii();
  return true;
}

QVariant AbstractElementByteArray::worker_toVariant() const {
  return m_value;
}

bool AbstractElementByteArray::worker_setData( const QVariant& data ) {
  m_value = data.toByteArray();
  return true;
}
