/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractelementbytearray.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Nov 15 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTELEMENTBYTEARRAY_H
#define ABSTRACTELEMENTBYTEARRAY_H


#include "abstractelementattribute.h"

#include <QByteArray>


/*!
 * \brief The AbstractElementByteArray class provides an abstract QByteArray
 *        attribute.
 */
class AbstractElementByteArray : public AbstractElementAttribute {

  Q_OBJECT

public:
  AbstractElementByteArray( AbstractElement* parent,
				 const QByteArray& value );

  const QByteArray& value() const { return m_value; }
  void setValue( const QByteArray& value ) { m_value = value; }

protected:
  QString  worker_toString()  const;
  bool     worker_setData( const QString& data );
  QVariant worker_toVariant() const;
  bool     worker_setData( const QVariant& data );

 private:
  QByteArray m_value;
};


#endif // ! ABSTRACTELEMENTBYTEARRAY_H
