/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractelementdouble.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Nov 8 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTELEMENTDOUBLE_H
#define ABSTRACTELEMENTDOUBLE_H


#include "abstractelementattribute.h"


/*!
 * \brief The AbstractElementDouble class provides an abstract double-
 *        precision floating-point attribute.
 */
class AbstractElementDouble : public AbstractElementAttribute {

  Q_OBJECT

public:
  AbstractElementDouble( AbstractElement* parent, double value );

  double value() const { return m_value; }
  void setValue( double value ) { m_value = value; }

protected:
  QString  worker_toString()  const;
  bool     worker_setData( const QString& data );
  QVariant worker_toVariant() const;
  bool     worker_setData( const QVariant& data );

 private:
  double m_value;
};


#endif // ! ABSTRACTELEMENTDOUBLE_H
