/*  -*- c++ -*-  (for Emacs)
 *
 *  doc.h
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    project.h
 *    Nodal
 *
 *    Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *    Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *    Original file:
 *
 *      project.h
 *      EverGreen
 *
 *      Created by Aidan Lane on Wed Jul 14 2004.
 *      Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */


//TODO: re-write the following doc for Digest:
/*
 * This is the "model" in the "model-view-controller" design.
 *
 * Changes are to be performed via derivitives of ProjectEvent being posted to an instance of this.
 * This allows for cleaner interaction, events to be logged and most of all an undo/redo feature.
 * Thread-safe as long as postEvent is used. TODO: is this entirely true???
 *
 * Currently this is both the model (aka. project or doc) AND the controller
 * (the controller ensures that data structures and views keep in sync and correct
 * to some rules).
 */

#ifndef DOC_H
#define DOC_H


#include <QObject>
#include "abstractmodel.h"
#include "domaccessiblestate.h"

#include <QPointer>

#include "docevents.h"


class DocController;


/*!
 * \brief The Doc class extends AbstractModel and DomAccessibleState to provide
 *        the basis for a document model.
 *
 * \em Warning: The doc controller must be set in order for instances of this
 * doc class or any of its model classes to send messages back to it.s
 */
class Doc : public QObject,
	    public AbstractModel,
	    public DomAccessibleState {

  Q_OBJECT

public:
  Doc( QObject* parent );
  Doc( const QString& name, QObject* parent );

  DocController* docController() const;
	
  const QString& name() const { return m_name; }
  const QString& filename() const { return m_filename; }

  /*!
   * Returns true IFF there have been modifications to the project since it was
   * last saved.
   * The value of this variable is set by the ProjectController.
   */
  bool isModified() const { return m_modified; }

  static const QByteArray& classKey();
  virtual const QByteArray& key() const { return classKey(); }

  virtual QDomElement domElement( QDomDocument& doc ) const;
  virtual void initFromDomElement( const QDomElement& e, InitModeFlags modeFlags );


protected:
  inline virtual void customEvent( QEvent* e ) {
    MEvent* me = dynamic_cast<MEvent*>(e); // slow :-(
    if ( me != 0 ) dispatchEvent(me);
  }
  virtual void dispatchEvent( MEvent* );

  virtual void changeControllerEvent( MChangeControllerEvent* );

  virtual void renameEvent( MRenameEvent* );
  virtual void changeFilenameEvent( MChangeFilenameEvent* );
  virtual void changeModifiedStateEvent( MChangeModifiedStateEvent* );


private:
  // Persistent state (use domElement() and initFromDOMElement()):
  QString m_name;

  // Temporary state:
  QString m_filename;
  bool    m_modified;

  // Temporary caches:
  QPointer<DocController> c_docController;
};


#endif // ! PROJECT_H
