/*  -*- c++ -*-  (for Emacs)
 *
 *  docevents.h
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    projectmodelevents.h
 *    Nodal
 *
 *    Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *    Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *    Original file:
 *
 *      projectevent.h
 *      EverGreen
 *
 *      Created by Aidan Lane on Sun Aug 01 2004.
 *      Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
 
#ifndef DOCEVENTS_H
#define DOCEVENTS_H


#include "modelevents.h"
#include "genericcontainers.h"


/*!
 * Base class to support document model events.
 *
 * These events can be logged in lists, which is required for undo/redo functionality.
 *
 * Extending MEvent offers thread-safe event queuing (using postEvent) and minimal coupling.
 */
class MDocEvent: public MEvent {
public:
  enum Type { 
    Rename               = MEvent::User,
    ChangeFilename,
    ChangeModifiedState,
    User                 = MEvent::User + 1000
  };

  MDocEvent( Type type )
    : MEvent((MEvent::Type)type) {}
};


class MRenameEvent : public MDocEvent, public NameContainer {
public:
  MRenameEvent( const QString& name )
    : MDocEvent(Rename),
      NameContainer(name) {}
};

class MChangeFilenameEvent : public MDocEvent, public FilenameContainer {
public:
  MChangeFilenameEvent( const QString& filename )
    : MDocEvent(ChangeFilename),
      FilenameContainer(filename) {}
};

class MChangeModifiedStateEvent : public MDocEvent {
public:
  MChangeModifiedStateEvent( bool documentModified )
    : MDocEvent(ChangeModifiedState), m_documentModified(documentModified) {}
  bool documentModified() const { return m_documentModified; }
private:
  bool m_documentModified;
};


#endif // ! DOCEVENTS_H
