/*  -*- c++ -*-  (for Emacs)
 *
 *  elementdocevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 10 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ELEMENTDOCEVENTS_H
#define ELEMENTDOCEVENTS_H


#include "attributedocevents.h"
#include "elementdoccontainers.h"


class MElementDocEvent : public MAttributeDocEvent {
public:
  enum Type {
    ElementAddPtr          = MAttributeDocEvent::User,
    ElementRemovePtr,
    ElementSetChangeOrder,
    User                   = MAttributeDocEvent::User + 1000
  };

  MElementDocEvent( Type type )
    : MAttributeDocEvent((MAttributeDocEvent::Type)type) {}
};


class MElementEvent : public MElementDocEvent,
		      public AbstractElementContainer {
public:
  MElementEvent( Type type,
		 AbstractElement* element )
    : MElementDocEvent(type),
      AbstractElementContainer(element) {}
};


class MElementSetEvent : public MElementDocEvent,
			 public AbstractElementSetContainer {
public:
  MElementSetEvent( Type type,
		    const AbstractElementSet& elements )
    : MElementDocEvent(type),
      AbstractElementSetContainer(elements) {}
};


/*! \brief Convenience class. */
class MElementAddPtrEvent : public MElementEvent {
public:
  MElementAddPtrEvent( AbstractElement* element )
    : MElementEvent(ElementAddPtr, element) {}
};

/*! \brief Convenience class. */
class MElementRemovePtrEvent : public MElementEvent {
public:
  MElementRemovePtrEvent( AbstractElement* element )
    : MElementEvent(ElementRemovePtr, element) {}
};


class MElementSetChangeOrderEvent : public MElementSetEvent,
				    public ElementOrderActionContainer {
public:
  MElementSetChangeOrderEvent( const AbstractElementSet& elements,
			       Action action )
    : MElementSetEvent(ElementSetChangeOrder, elements),
      ElementOrderActionContainer(action) {}
};


#endif //  ! ELEMENTDOCEVENTS_H
